import { Component, EventEmitter, Input, OnDestroy, OnChanges, OnInit, Output, ApplicationRef, ChangeDetectorRef } from '@angular/core';
import { JsonPipe } from '@angular/common';


@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent implements OnInit, OnChanges, OnDestroy {

  // 储存数据用
  saveKey = "dfzx_cocos_dqq";
  // 储存对象
  item;

  constructor(private appRef: ApplicationRef, private changeDetectorRef: ChangeDetectorRef) {

  }

  addQuestion() {
    this.item.questionList.push({
      questionAudio: '',
      speedLevel: 1,
      rigthNumber: 5,
      answerList: []
    });
    this.save();
  }

  removeQuestion(idx) {
    this.item.questionList.splice(idx, 1);
    console.log('汪汪汪');
    this.save();
  }

  addAnswer(idx) {
    this.item.questionList[idx].answerList.push({
      answerAudio: '',
      answerTxt: '',
      answerImg: '',
      answerType: 'img',
      rightAnswer: false
    });
    this.save();
  }

  removeAnswer(questionIdx, answerIdx) {
    this.item.questionList[questionIdx].answerList.splice(answerIdx, 1);
    this.save();
  }

  onAnswerAuidoUploadSuccess(e, questionIdx, answerIdx) {
    this.item.questionList[questionIdx].answerList[answerIdx].answerAudio = e.url;
    this.save();
  }

  onAnswerImageUploadSuccess(e, questionIdx, answerIdx) {
    this.item.questionList[questionIdx].answerList[answerIdx].answerImg = e.url;
    this.save();
  }

  removeAnswerImage(questionIdx, answerIdx) {
    this.item.questionList[questionIdx].answerList[answerIdx].answerImg = '';
    this.save();
  }

  setAnswerRight(questionIdx, answerIdx, right) {
    this.item.questionList[questionIdx].answerList[answerIdx].rightAnswer = right;
    this.save();
  }

  onQuestionAuidoUploadSuccess(e, questionIdx) {
    this.item.questionList[questionIdx].questionAudio = e.url;
    this.save();
  }

  radioChange(event, questionIdx, answerIdx) {
    this.item.questionList[questionIdx].answerList[answerIdx].answerType = event;
    this.save();
  }

  ngOnInit() {

    this.item = {
      questionList: []
    };

    // 获取存储的数据
    (<any>window).courseware.getData((data) => {

      if (data) {
        this.item = data;
      }

      this.init();
      this.changeDetectorRef.markForCheck();
      this.changeDetectorRef.detectChanges();
      this.refresh();

    }, this.saveKey);
  }

  ngOnChanges() {
  }

  ngOnDestroy() {
  }

  init() {

  }


  /**
   * 储存图片数据
   * @param e
   */
  onImageUploadSuccess(e, key) {

    this.item[key] = e.url;
    this.save();
  }

  /**
   * 储存音频数据
   * @param e
   */
  onAudioUploadSuccess(e, key) {
    this.item[key] = e.url;
    this.save();
  }

  /**
   * 储存数据
   */
  save() {
    (<any>window).courseware.setData(this.item, null, this.saveKey);

    this.refresh();
    this.changeDetectorRef.markForCheck();
    this.changeDetectorRef.detectChanges();
    console.log('this.item = ' + JSON.stringify(this.item));
  }

  /**
   * 刷新 渲染页面
   */
  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }

}