import {Component, EventEmitter, Input, OnDestroy, OnChanges, OnInit, Output, ApplicationRef, ChangeDetectorRef} from '@angular/core';



@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent implements OnInit, OnChanges, OnDestroy {

  // 储存数据用
  saveKey = "pu_app_xuanze";
  // 储存对象
  item;


  constructor(private appRef: ApplicationRef,private changeDetectorRef: ChangeDetectorRef) {

  }


  ngOnInit() {

    this.item = {};
    // 获取存储的数据
    (<any> window).courseware.getData((data) => {

      if (data) {
        this.item = data;
      }

      // this.item = JSON.parse('{"questionType":"text","answerType":"text","answerArr":[{"text":"","pic_url":"","answerRight":"0"},{"text":"","pic_url":"","answerRight":"0"},{"text":"","pic_url":"","answerRight":"0"}],"questionArr":[{"questionType":"text","answerType":"text","answerArr":[{"text":"aaaaa","pic_url":"","answerRight":"0"},{"text":"bb","pic_url":"","answerRight":"1"},{"text":"ccccc","pic_url":"","answerRight":"0","audio_url":"http://staging-teach.cdn.ireadabc.com/b004c86f1a26a367cfa329b11e365f0f.mp3"}],"text":"11112","audio_url":"http://staging-teach.cdn.ireadabc.com/ce693028675b6324506ebfe45974e4c1.mp3"},{"questionType":"pic","answerType":"pic","answerArr":[{"text":"","pic_url":"http://staging-teach.cdn.ireadabc.com/56cf568aebe7ddfa75a0ac3366942241.png","answerRight":"0"},{"text":"","pic_url":"http://staging-teach.cdn.ireadabc.com/9340adda6869dd31a63b9d85a3f9ffe5.png","answerRight":"1","audio_url":"http://staging-teach.cdn.ireadabc.com/6725c1d93e9dbfbfc937ce3611b12631.mp3"}],"text":"22222","pic_url":"http://staging-teach.cdn.ireadabc.com/2d29dffee7d7fefea19ef7c8ea566072.png"},{"questionType":"audio","answerType":"audio","answerArr":[{"text":"","pic_url":"","answerRight":"0","audio_url":"http://staging-teach.cdn.ireadabc.com/519b8f68a4ebd96ee0405d945ca65489.mp3"},{"text":"","pic_url":"","answerRight":"1","audio_url":"http://staging-teach.cdn.ireadabc.com/b363bf8aaddd56ec977ce233f5d46be1.mp3"}],"audio_url":"http://staging-teach.cdn.ireadabc.com/7934cdcec68eabe639020bad5420d7f8.mp3"},{"questionType":"video","answerType":"text","answerArr":[{"text":"444444","pic_url":"","answerRight":"0"},{"text":"3333333","pic_url":"","answerRight":"1","audio_url":"http://staging-teach.cdn.ireadabc.com/f67df2a0dd444837299a3bede235c9d6.mp3"}],"video_url":"http://staging-teach.cdn.ireadabc.com/1ac7eb5446e806b562ec47ad88b092c9.mp4"}],"audio_url":"http://staging-teach.cdn.ireadabc.com/ce693028675b6324506ebfe45974e4c1.mp3"}');
      console.log("this.item: ", JSON.stringify(this.item));

      this.init();
      this.changeDetectorRef.markForCheck();
      this.changeDetectorRef.detectChanges();
      this.refresh();

    }, this.saveKey);

  }


  ngOnChanges() {
  }

  ngOnDestroy() {
  }



  init() {

    if (!this.item.groupArr) {
      this.item.groupArr = [];
    }

    // if (!this.item.questionArr) {
    //   this.item.questionArr = [];
    // }

    // if (!this.item.questionType) {
    //   this.item.questionType = 'text';
    //   this.item.answerType = 'text';
    //   this.item.answerArr = [];
    // }
  }

  addGroup() {
    this.item.groupArr.push({
      questionArr: []
    });
    this.save();
  }

  deleteGroup(i) {
    this.item.groupArr.splice(i , 1);
    this.save();
  }

  addQuestion(group) {
    const ques = {
      questionType : 'text',
      answerType : 'text',
      answerArr : [],
    }

    group.questionArr.push(ques);
    this.save();
  }

  deleteQuestion(grou, i) {
    grou.questionArr.splice(i , 1);
    this.save();
  }


  deleteAnswer(item, i) {
    item.answerArr.splice(i, 1);
    this.save();
  }

  addAnswer(q) {
    q.answerArr.push({
      text: '',
      pic_url: '',
      answerRight: '0',
    });
    this.save();
  }


  /**
   * 储存图片数据
   * @param e
   */
  onImageUploadSuccess(e, key, item = null) {

    if (!item) {
      item = this.item;
    }
    item[key] = e.url;
    this.save();
  }

  /**
   * 储存音频数据
   * @param e
   */
  onAudioUploadSuccess(e, key, item=null) {

    if (!item) {
      item = this.item;
    }
    item[key] = e.url;
    this.save();
  }


  onVideoUploadSuccess(e, item) {
    item.video_url = e.url;
    this.save();
  }

  /**
   * 储存数据
   */
  save() {
    (<any> window).courseware.setData(this.item, null, this.saveKey);
    this.refresh();
  }

  /**
   * 刷新 渲染页面
   */
  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }

}

