import {ApplicationRef, Component, EventEmitter, Input, OnChanges, OnDestroy, Output} from '@angular/core';
import { NzMessageService, UploadXHRArgs, UploadFile } from 'ng-zorro-antd';


@Component({
  selector: 'app-form-group',
  templateUrl: './form-group.component.html',
  styleUrls: ['./form-group.component.scss']
})
export class FormGroupComponent implements OnDestroy, OnChanges {


  @Input()
  group_arr = [];

  @Input()
  isChildren = false;

  uploading = false;
  progress = 0;
  @Input()
  btnName = '配置龙骨动画';
  @Input()
  animaNames = [];

  @Input()
  skeJsonData = {};
  @Input()
  texJsonData = {};
  @Input()
  texPngData = {};
  
  @Output()
  save = new EventEmitter();

  @Output() 
  addGroup = new EventEmitter();

  @Output()
  refreshEmitter = new EventEmitter();

  @Output()
  uploadDirector = new EventEmitter();


  uploadUrl;
  uploadData;

  animaPanelVisible = false;

  isSkeJsonLoading = false;
  isTexJsonLoading = false;
  isTexPngLoading = false;

  constructor(private appRef: ApplicationRef, private nzMessageService: NzMessageService) {

    this.uploadUrl = (<any> window).courseware.uploadUrl();
    this.uploadData = (<any> window).courseware.uploadData();

    window['air'].getUploadCallback = (url, data) => {
      this.uploadUrl = url;
      this.uploadData = data;
    };

   
  }
  ngOnChanges() {
 
  }



  onImageUploadSuccess(e, data) {
    data['value'] = e.url;
    this.sendSaveGroup();
  }
  onAudioUploadSuccess(e, data) {
    data['value'] = e.url;
    this.sendSaveGroup();
  }
  onVideoUploadSuccess(e, data) {
    data['value'] = e.url;
    this.sendSaveGroup();
  }
  onSaveAnima(e, anim_arr, index) {
    anim_arr[index] = e;
    this.sendSaveGroup();
  }


  addSubGroupBtnClick(group) {
    const {group_arr} = group;
    const oneGroup = this.getOneGroup();
    group_arr.push(oneGroup);
    this.sendSaveGroup();
  }
  deleteSubGroupBtnClick(group, index) {
    const {group_arr} = group;
    group_arr.splice(index, 1);
    this.sendSaveGroup();
  }

  addAnimBtnClick(group) {
    const {anim_arr} = group;
    anim_arr.push({});
    this.sendSaveGroup();
  }
  deleteAnimBtnClick(group, index) {
    const {anim_arr} = group;
    anim_arr.splice(index, 1);
    this.sendSaveGroup();
  }

  addVideoBtnClick(group) {
    const {video_arr} = group;
    video_arr.push({});
    this.sendSaveGroup();
  }
  deleteVideoBtnClick(group, index) {
    const {video_arr} = group;
    video_arr.splice(index, 1);
    this.sendSaveGroup();
  }

  addAudioBtnClick(group) {
    const {audio_arr} = group;
    audio_arr.push({});
    this.sendSaveGroup();
  }
  deleteAudioBtnClick(group, index) {
    const {audio_arr} = group;
    audio_arr.splice(index, 1);
    this.sendSaveGroup();
  }

  addImageBtnClick(group) {
    const {image_arr} = group;
    image_arr.push({});
    this.sendSaveGroup();
  }
  deleteImageBtnClick(group, index) {
    const {image_arr} = group;
    image_arr.splice(index, 1);
    this.sendSaveGroup();
  }

  addTextBtnClick(group) {
    const {text_arr} = group;
    text_arr.push({});
    this.sendSaveGroup();
  }
  deleteTextBtnClick(group, index) {
    const {text_arr} = group;
    text_arr.splice(index, 1);
    this.sendSaveGroup();
  }


  
  getOneGroup() {
    const group = {
      text_arr: [],
      anim_arr: [],
      image_arr: [],
      audio_arr: [],
      video_arr: [],
      group_arr: [],
    }
    return group;
  }


  addGroupBtnClick() {
    this.group_arr.push({
      text_arr: [],
      anim_arr: [],
      image_arr: [],
      audio_arr: [],
      video_arr: [],
      group_arr: [],
    })
    this.sendSaveGroup();
  }

  deleteGroupBtnClick(index) {
    this.group_arr.splice(index, 1);
    this.sendSaveGroup();
  }


  saveFormGroup(e, subGroupData) {
    subGroupData.group_arr = e;
    this.sendSaveGroup();
  }

  sendSaveGroup() {
    this.save.emit(this.group_arr);
  }


  beforeUpload(file) {
    const reader = new FileReader();
    reader.onload = e => {
      const fileContent = e.target.result;
      console.log('File content:', fileContent);
    };
    reader.readAsText(file);
  }

  handleChange(e) {

    console.log("e: ", e);
    const {fileList} = e;
    if (fileList) {
      for (let i=0; i<fileList.length; i++) {
        const {status} = fileList[i];
        if (status != 'done') {
          return;
        }
      }
    }

    this.uploadDirector.emit(fileList)
    
  }

  /**
   * 刷新 渲染页面
   */
  refresh() {

    // this.refreshEmitter.emit();
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }


  ngOnDestroy() {
  }

}
