import { Component, EventEmitter, Input, OnDestroy, OnChanges, OnInit, Output, ApplicationRef, ChangeDetectorRef } from '@angular/core';
import { JsonPipe } from '@angular/common';
import { ComponentBase } from './ComponentBase';


@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent extends ComponentBase implements OnInit, OnChanges, OnDestroy {

  // 储存数据用
  saveKey = "dg08_hx";
  // 储存对象
  item: any = {
    // score: 0,
    title: '捕捞海星',
    // questionText: "彩蛋里藏了哪些魔法卡牌呢？亲爱的小玩家，快用锤子砸开彩蛋，魔法卡牌就会露出来，只要正确地说出魔法咒语，你就能获得这张魔法卡牌。 游戏结束后，根据获得的魔法卡牌数量，你将获得相应的能量石奖励！开始挑战吧！",
    // questionTextAudio: "http://staging-teach.cdn.ireadabc.com/61b41f87fffc8390a519668fece764d3_l.mp3",
    questions: [],
  };

  // item: any = {
  //   title: '幸运大转盘',
  //   questionText: "亲爱的小玩家，游戏马上就要开始啦！请动动手指转动转盘，当转盘停止，注意观察指针指向的魔法图片，并大声说出魔法咒语，魔法咒语正确，你就可以获得一张魔法卡牌。 游戏结束后，根据获得的魔法卡牌数量，你将获得相应的能量石奖励！开始挑战吧！",
  //   questionTextAudio: "http://staging-teach.cdn.ireadabc.com/18ebee93b3eabcd55649a01366431af7.mp3",
  //   questions: [],
  // };

  isVisible = false;
  deleteTitle = "是否删除题目";
  deleteCallback = function () { };
  openDelete(title, callback) {
    this.deleteCallback = callback;
    this.deleteTitle = title;
    this.isVisible = true;
  }
  handleCancel() {
    this.isVisible = false;
  }
  handleOk() {
    this.deleteCallback && this.deleteCallback();
    this.handleCancel();
  }

  addQuestion() {
    this.item.questions.push({
      // type: 'img',
      audio: '',
      text: '',
      // image: '',
      time: null,
      duration: "",
      // word: '',
      audioName: "",
    });
    this.save();
  }

  removeQuestion(idx) {
    this.openDelete("确定删除题目？", () => {
      this.item.questions.splice(idx, 1);
      this.save();
    })
  }
  copyQuestion(idx) {
    let data = this.item.questions[idx]
    this.item.questions.push(JSON.parse(JSON.stringify(data)));
    this.save();
  }
  deleteBgAudio() {
    this.item.bgAudio = "";
    this.item.audioBgName = "";
    this.save();
  }
  // addOption(idx) {
  //   if (this.item.questions[idx].options.length == 4) return;
  //   this.item.questions[idx].options.push({
  //     text: '',
  //     audio: '',
  //     image: '',
  //     word: '',
  //   });
  //   this.save();
  // }

  // removeOption(idx, n) {
  //   this.openDelete("确定删除选项？", () => {
  //     this.item.questions[idx].options.splice(n, 1);
  //     this.save();
  //   })
  // }
  ngChange() {
    this.save();
  }
}