import pg from "./tool/pgdg10_dg10_ty";

const { ccclass, property } = cc._decorator;

@ccclass
export default class dg_xiaodi extends cc.Component {

    @property(cc.Node)
    aniRole: cc.Node = null;
    @property moveX: number = 500;

    private defaultX: number;
    onLoad() {
        this.defaultX = this.aniRole.x;
    }
    private audioIdEnter: any;
    playEnter(audioUrl) {
        return new Promise((resolve, reject) => {
            this.node.active = true;
            let startX = this.defaultX + this.moveX;
            this.aniRole.x = startX;
            cc.tween(this.aniRole)
                .call(() => {
                    pg.view.playDBAnimation(this.aniRole, 'run');
                    if (this.moveX < 0) {
                        this.aniRole.scaleX = -this.aniRole.scaleX;
                    }
                })
                .to(0.5, { x: 0 })
                .call(() => {
                    if (this.moveX < 0) {
                        this.aniRole.scaleX = -this.aniRole.scaleX;
                    }
                    pg.view.playDBAnimation(this.aniRole, 'talk');

                    pg.audio.playAudioByUrl(audioUrl, () => {
                        this.audioIdEnter = null;

                        cc.tween(this.aniRole)
                            .call(() => {
                                pg.view.playDBAnimation(this.aniRole, 'run');
                                if (this.moveX < 0) {
                                    this.aniRole.scaleX = -this.aniRole.scaleX;
                                }
                            })
                            .to(0.5, { x: -1800 })
                            .call(() => {
                                this.scheduleOnce(() => {
                                    resolve('');
                                }, 0.5)
                            })
                            .start();
                    }, audioId => {
                        this.audioIdEnter = audioId;
                    })
                })
                .start();
        });
    }
    playEnterEnd() {
        this.node.active = false;
        if (this.audioIdEnter) {
            cc.audioEngine.stopEffect(this.audioIdEnter)
        }
    }

    private audioIdOver: any;
    playOver(audioUrl) {
        this.node.active = true;
        let startX = this.defaultX + this.moveX;
        this.aniRole.x = startX;
        cc.tween(this.aniRole)
            .call(() => {
                pg.view.playDBAnimation(this.aniRole, 'run');
                if (this.moveX < 0) {
                    this.aniRole.scaleX = -this.aniRole.scaleX;
                }
            })
            .to(0.3, { x: this.defaultX })
            .call(() => {
                if (this.moveX < 0) {
                    this.aniRole.scaleX = -this.aniRole.scaleX;
                }
                pg.view.playDBAnimation(this.aniRole, 'talk');
                pg.audio.playAudioByUrl(audioUrl, () => {
                    this.audioIdOver = null;
                    pg.view.playDBAnimation(this.aniRole, 'normal');
                }, audioId => {
                    this.audioIdOver = audioId;
                })
            })
            .start();
    }
    playOverEnd() {
        this.node.active = false;
        if (this.audioIdOver) {
            cc.audioEngine.stopEffect(this.audioIdOver)
        }
    }
    start() {

    }

    update(dt) {

    }
}

