export enum FISH_OUT {
    RUNNING,
    TOUCH,
    CATCH,
    ESCAP,
    OUT
}
export class Fish {
    public isOut: number;
    public node: cc.Node;
    public isLeft: boolean;//在左侧 向右运动
    constructor() {
        this.isOut = 0;
        this.isLeft = Math.random() < 0.5;
    }

}
export class Option {
    public type: string;
    public image: string;
    public audio: string;
    public text: string;
    public right: boolean;
    constructor(data) {
        this.type = data.type;
        this.image = data.image;
        this.audio = data.audio;
        this.text = data.text;
        this.right = data.isRight == 1;
    }
}

export class Question {
    public txt;
    public audioUrl;
    public data;
    public id: number;
    public count: number;
    public time: number;
    public touchRight: boolean;
    public parent;
    public options: Array<Option>;
    public rights: Array<Option>;
    constructor(data, id) {
        this.id = id;
        // this.type = data.type;
        this.count = 0;
        this.txt = data.text;
        this.time = data.duration;
        // this.picUrl = data.image;
        this.audioUrl = data.audio;
        // this.right = data.right;
        this.touchRight = false;
        this.rights = [];
        this.options = data.options.map(op => new Option(op))
    }
    addRight(option) {
        this.rights.push(option)
    }
    checkRight() {
        let rights = this.options.filter(op => op.right);
        return this.rights.length >= rights.length
    }
}
export class Item {
    public page;
    public audio;
    public duration;
    public optionList;
    public checkMore: boolean;
    public rNum: number;
    constructor(data, page) {
        this.audio = data.questionAudio;
        this.duration = data.duration;
        let id = 0;

        // this.optionList = data.options.map(o => {
        //     return new Option(o);
        // })

        this.optionList.sort(function () {
            return (0.5 - Math.random());
        });
        this.rNum = 0;
        for (let i = 0; i < this.optionList.length; i++) {
            if (this.optionList[i].right) this.rNum++;
        }
        this.checkMore = this.rNum > 1;
        this.page = page;
    }
}
class Role {
    public score: number;
    public right: number;
    public error: number;
    public voices: Array<any>;
    constructor() {
        this.score = 0;
        this.error = 0;
        this.right = 0;
        this.voices = [];
    }
    addScore(score: number = 1) {
        this.score += score;
    }
    addError(score: number = 1) {
        this.error += score;
    }
    addRight() {
        this.right += 1;
    }
    addVoice(obj: any) {
        this.voices.push(obj);
    }
}
export class Player extends Role {
    constructor() {
        super();
    }
    reset() {
        this.score = 0;
        this.error = 0;
        this.right = 0;
        this.voices = [];
    }
}
export class Robot extends Role {
    constructor() {
        super();
    }
    reset() {
        this.score = 0;
        this.error = 0;
        this.right = 0;
        this.voices = [];
    }
}
export enum GAME_STATE {
    WAIT,
    RUNNING,
    OVER
}
export default class Game {
    private static ins: Game;
    public static getIns(): Game {
        if (!Game.ins) Game.ins = new Game();
        return Game.ins;
    }
    private data: any;
    private lists: Array<Question>
    public player: Player;
    public robot: Robot;
    public state: GAME_STATE;
    public total: number;

    constructor() {
        this.start = false;
        this.lists = [];
        this.player = new Player();
        this.robot = new Robot();
        this.state = GAME_STATE.WAIT;
    }
    get len() {
        return this.lists.length;
    }
    public singleGame: boolean;
    public question: { text, audio };
    public title: string;
    // public bgAudio: string;
    // public questionText: string;
    public init(data) {
        this.singleGame = !data.onlineFlg;
        // this.question = { text: data.questionText, audio: data.questionTextAudio };
        this.title = data.title;
        // this.bgAudio = data.bgAudio || "";
        // this.questionText = data.questionText;
        this.start = false;
        this.lists = [];
        this.data = data.questions;
    }
    public start: boolean;
    public idx: number;
    reset() {
        this.player.reset();
        this.robot.reset();
        this.idx = 0;
        this.start = true;
        this.lists = [];
        for (let i = 0; i < this.data.length; i++) {
            let data = this.data[i];
            this.lists.push(new Question(data, i + 1));
        }
        this.state = GAME_STATE.WAIT;
        this.total = this.lists.length;
    }
    // public getCardInfo() {
    //     let option: Question = this.lists.splice(0, 1)[0];
    //     // if (this.lists.length > 0) {
    //     //     let random = Math.floor(Math.random() * this.lists.length);
    //     //     option = this.lists.splice(random, 1)[0];
    //     // } else {
    //     //     option = null;
    //     // }
    //     console.log(" this.cardInfo=======", option)
    //     return option;
    // }
    getCurrentPage(): Question {
        return this.lists[this.idx];
    }
    getTotalPageNum() {
        return this.lists.length;
    }
    getCurrentPageNum() {
        return this.idx;
    }
    addPage() {
        this.idx += 1;
    }
    get getTotal() {
        return this.lists.length;
        // this.total = 0;
        // this.lists.forEach((item) => {
        //     this.total += item.rNum;
        // })
        // return this.total;
    }
    get isOver() {
        return this.idx > this.lists.length;
    }
}