export class Option {
    public type: string;
    public image: string;
    public audio: string;
    public text: string;
    public right: boolean;
    constructor(data) {
        this.type = data.type;
        this.image = data.image;
        this.audio = data.audio;
        this.text = data.text;
        this.right = data.isRight == 1;
    }
}

export class Question {
    public txt;
    public audioUrl;
    public data;
    public id: number;
    public count: number;
    public time: number;
    public touchRight: boolean;
    public parent;
    public options: Array<Option>;
    public rights: Array<Option>;
    constructor(data, id) {
        this.id = id;
        this.count = 0;
        this.txt = data.text;
        this.time = data.duration;
        this.audioUrl = data.audio;
        this.touchRight = false;
        this.rights = [];
        this.options = data.options.map(op => new Option(op))
    }
    addRight(option) {
        this.rights.push(option)
    }
    checkRight() {
        let rights = this.options.filter(op => op.right);
        return this.rights.length >= rights.length
    }
}
export enum GAME_STATE {
    WAIT,
    RUNNING,
    OVER
}
export default class Game {
    private static ins: Game;
    public static getIns(): Game {
        if (!Game.ins) Game.ins = new Game();
        return Game.ins;
    }
    private data: any;
    private lists: Array<Question>
    public state: GAME_STATE;
    public total: number;

    constructor() {
        this.start = false;
        this.lists = [];
        this.state = GAME_STATE.WAIT;
    }
    get len() {
        return this.lists.length;
    }
    public singleGame: boolean;
    public question: { text, audio };
    public title: string;
    // public bgAudio: string;
    // public questionText: string;
    public init(data) {
        this.singleGame = !data.onlineFlg;
        // this.question = { text: data.questionText, audio: data.questionTextAudio };
        this.title = data.title;
        // this.bgAudio = data.bgAudio || "";
        // this.questionText = data.questionText;
        this.start = false;
        this.lists = [];
        this.data = data.questions;
    }
    public start: boolean;
    public idx: number;
    reset() {
        this.idx = 0;
        this.start = true;
        this.lists = [];
        for (let i = 0; i < this.data.length; i++) {
            let data = this.data[i];
            this.lists.push(new Question(data, i + 1));
        }
        this.state = GAME_STATE.WAIT;
        this.total = this.lists.length;
    }
    getCurrentPage(): Question {
        return this.lists[this.idx];
    }
    getTotalPageNum() {
        return this.lists.length;
    }
    getCurrentPageNum() {
        return this.idx;
    }
    addPage() {
        this.idx += 1;
    }
    get getTotal() {
        return this.lists.length;
    }
    get isOver() {
        return this.idx > this.lists.length;
    }
}