// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const { ccclass, property } = cc._decorator;

@ccclass
export default class fishs extends cc.Component {

    @property
    public left2Right: boolean = false;

    @property
    public index: number = 1;
    // 花费时间
    @property
    public costTime: number = 10;
    // 花费时间
    @property
    public waitTime: number = 3;

    // 起始位置
    private startPos: cc.Vec2;
    // 结束位置
    private endPos: cc.Vec2;

    private leftPos: Array<cc.Vec2> = [cc.v2(-1400, 120), cc.v2(-1200, 360), cc.v2(-1200, 20)];
    private rightPos: Array<cc.Vec2> = [cc.v2(1400, 120), cc.v2(1200, 360), cc.v2(1200, 20)];
    private timer: any;
    onLoad() {
        // 默认位置在左侧
        this.startPos = this.left2Right ? this.leftPos[this.index - 1] : this.rightPos[this.index - 1];
        this.endPos = this.left2Right ? this.rightPos[this.index - 1] : this.leftPos[this.index - 1];
        this.timer = setTimeout(() => {
            this.startMove();
        }, this.waitTime * 1000);
    }

    startMove() {
        this.node.setPosition(this.startPos);
        cc.tween(this.node).to(this.costTime, { x: this.endPos.x, y: this.endPos.y }).start();
        this.timer = setTimeout(() => {
            this.startMove();
        }, this.costTime * 1000 + 100);
    }
    stopMove() {
        cc.Tween.stopAllByTarget(this.node);
        this.timer && clearTimeout(this.timer);
    }

    start() {

    }

    update(dt) {

    }
}
