
// 对应模板的名称，这个可以不写，但是最好是能写上，同时开发多个模板的情况下如果不写这个，本地缓存可能会存在混乱
var key = "dg_dictation_config";

new Vue({
  el: '.edit-data',
  created() {
    window.courseware.getData((checkedArr) => {
      //数据加载完，才算页面加载完成
      //获取数据
      this.loadRows(checkedArr||[]);
      this.loadFaf(checkedArr||[]);
    },key); 
  },
  data() {
    return {
      rows: [],
      fafRows: [],
      fafId: 4258, // FAF 教材
    }
  },
  methods: {
    loadRows(checkedArr) {
      $.ajax({
        type: "GET",
        contentType: "application/x-www-form-urlencoded; charset=utf-8",
        url: `${this.compDomain}api/dige/non/v1/gradetree/list`,
        success: (xhr) => {
        },
        error: (xhr, e) => {
        },
        complete: (xhr) => {
          this.rows = xhr.responseJSON.rows.filter(item => item.id != 4258).map(item => {
            return {...item, checked: checkedArr.includes(item.id)}
          });
        }
      });
    },
    loadFaf (checkedArr) {
      $.ajax({
        type: "GET",
        contentType: "application/x-www-form-urlencoded; charset=utf-8",
        url: `${this.compDomain}api/dige/non/v1/gradetree/list?pid=${this.fafId}`,
        success: (xhr) => {
        },
        error: (xhr, e) => {
        },
        complete: (xhr) => {
          this.fafRows = xhr.responseJSON.rows.map(item => {
            return {...item, checked: checkedArr.includes(item.id)}
          });
        }
      });
    },
    save() {
      const rows = [];
      for (let i = 0; i < this.rows.length; i++) {
        const row = this.rows[i];
        if(row.checked) {
          rows.push(row.id);
        }
      }
      for (let i = 0; i < this.fafRows.length; i++) {
        const row = this.fafRows[i];
        if(row.checked) {
          rows.push(row.id);
        }
      }
      // 保存新增或修改的数据
      window.courseware.setData(rows, () => {
        //保存数据也是异步的
        this.$message.success("保存成功");
      },key); 
    }
  },
  computed: {
    compDomain: function () {
      const protocolStr = document.location.protocol;
      if (document.domain.indexOf("staging") < 0 && document.domain != 'localhost') {
        return `${protocolStr}//openapi.iteachabc.com/`;
      }
      return `${protocolStr}//staging-openapi.iteachabc.com/`;
    },
  }
});
