import axios from "axios";
const org = 523;
const dpe_root = 275931;
const base_url = "https://ema.iteachabc.com/api/syllabus/v1";

export const getSyllabusListById = (syllabus_id) => {
    return new Promise(async (resolve, reject) => {
        const res = await axios.get(`${base_url}/list?orgid=${org}&pid=${syllabus_id?syllabus_id:dpe_root}`);
        resolve(res.data);
    })
}

export const getFirstCoursewareBySyllId = (syllabus_id) => {
    return new Promise(async (resolve, reject) => {
        const res = await axios.get(`${base_url}/getdata?syllabusid=${syllabus_id}`);
        resolve(res.data);
    })
}

export const getCoursewarePageBySyllId = (syllabus_id, page) => {
    return new Promise(async (resolve, reject) => {
        const res = await axios.get(`${base_url}/getpagedata?syllabusid=${syllabus_id}&page=${page}`);
        resolve(res.data);
    })
}

export const getAllCoursewareBySyllId = (syllabus_id) => {
    return new Promise(async (resolve, reject) => {
        const res = await axios.get(`${base_url}/getdatalist?syllabusids=${syllabus_id}`);
        resolve(res.data);
    })
}

export const getPidPathName = (pid_path) => {
    return new Promise(async (resolve, reject) => {
        const res = await axios.get(`${base_url}/pathname?pid_path=${pid_path}`);
        resolve(res.data);
    })
}