import Vue from 'vue'
import ElementUI from 'element-ui';
import 'element-ui/lib/theme-chalk/index.css';
import App from './App.vue'
import * as echarts from 'echarts';
import { getDPEData } from './api/dep'

Vue.use(ElementUI);

Vue.config.productionTip = false
Vue.prototype.$getData = () => {
  console.log("===== getData =====");
  return new Promise((resolve, reject) => {
    (window).courseware.getData((data) => {
      console.log(data);
      resolve(data)
    }, "default_key")
  })
}

Vue.prototype.$getDPEData = getDPEData;

Vue.prototype.$setData = (data) => {
  console.log("===== setData =====");
  console.log(data);
  (window).courseware.setData(data, null, "default_key")
}

Vue.prototype.$echarts = echarts

new Vue({
  render: function (h) { return h(App) },
}).$mount('#app')
