import { asyncDelay, onHomeworkFinish } from "../script/util_dpe_point_reads_editor";
import { MyCocosSceneComponent } from "../script/MyCocosSceneComponent_dpe_point_reads_editor";

const { ccclass, property } = cc._decorator;

@ccclass
export default class SceneComponent extends MyCocosSceneComponent {

    addPreloadImage() {
        // TODO 根据自己的配置预加载图片资源
        this._imageResList.push({ url: this.data.pic_url });
        this._imageResList.push({ url: this.data.pic_url_2 });
    }

    addPreloadAudio() {
        // TODO 根据自己的配置预加载音频资源
        this._audioResList.push({ url: this.data.audio_url });
    }

    addPreloadAnima() {

    }

    async onLoadEnd() {
        // TODO 加载完成后的逻辑写在这里, 下面的代码仅供参考
        this.initData();
        this.initView();
        this.initListener();
    }

    _cantouch = null;
    initData() {
        // 所有全局变量 默认都是null 
        this._cantouch = true;
    }

    initView() {
        this.initBg();
        this.initPic();
        this.initBtn();
        this.initIcon();
    }

    initBg() {
        const bgNode = cc.find('Canvas/bg');
        bgNode.scale = this._mapScaleMax;
    }

    pic1 = null;
    pic2 = null;
    initPic() {
        const canvas = cc.find('Canvas');
        const maxW = canvas.width * 0.7;

        this.getSprNodeByUrl(this.data.pic_url, (sprNode) => {
            const picNode1 = sprNode;
            picNode1.scale = maxW / picNode1.width;
            picNode1.baseX = picNode1.x;
            canvas.addChild(picNode1);
            this.pic1 = picNode1;

            const labelNode = new cc.Node();
            labelNode.color = cc.Color.YELLOW;
            const label = labelNode.addComponent(cc.Label);
            label.string = this.data.text;
            label.fontSize = 60;
            label.lineHeight = 60;
            label.font = cc.find('Canvas/res/font/BRLNSDB').getComponent('cc.Label').font;
            picNode1.addChild(labelNode);
        });

        this.getSprNodeByUrl(this.data.pic_url_2, (sprNode) => {
            const picNode2 = sprNode;
            picNode2.scale = maxW / picNode2.width;
            canvas.addChild(picNode2);
            picNode2.x = canvas.width;
            picNode2.baseX = picNode2.x;
            this.pic2 = picNode2;

            const labelNode = new cc.Node();
            const label = labelNode.addComponent(cc.RichText);
            const size = 60
            label.font = cc.find('Canvas/res/font/BRLNSDB').getComponent(cc.Label).font;
            label.string = `<outline color=#751e00 width=4><size=${size}><color=#ffffff>${this.data.text}</color></size></outline>`
            label.lineHeight = size;
            picNode2.addChild(labelNode);
        });

    }

    initIcon() {
        const iconNode = this.getSprNode('icon');
        iconNode.zIndex = 5;
        iconNode.anchorX = 1;
        iconNode.anchorY = 1;
        iconNode.parent = cc.find('Canvas');
        iconNode.x = iconNode.parent.width / 2 - 10;
        iconNode.y = iconNode.parent.height / 2 - 10;

        iconNode.on(cc.Node.EventType.TOUCH_START, () => {
            this.playAudioByUrl(this.data.audio_url);
        })
    }

    curPage = null;
    initBtn() {

        this.curPage = 0;
        const bottomPart = cc.find('Canvas/bottomPart');
        bottomPart.zIndex = 5; // 提高层级

        bottomPart.x = bottomPart.parent.width / 2;
        bottomPart.y = -bottomPart.parent.height / 2;

        const leftBtnNode = bottomPart.getChildByName('btn_left');
        //节点中添加了button组件 则可以添加click事件监听
        leftBtnNode.on('click', () => {
            if (!this._cantouch) {
                return;
            }
            if (this.curPage == 0) {
                return;
            }
            this.curPage = 0
            this.leftMove();

            this.playLocalAudio('btn');
        })

        const rightBtnNode = bottomPart.getChildByName('btn_right');
        //节点中添加了button组件 则可以添加click事件监听
        rightBtnNode.on('click', () => {
            if (!this._cantouch) {
                return;
            }
            if (this.curPage == 1) {
                return;
            }

            this.curPage = 1
            this.rightMove();

            // 游戏结束时需要调用这个方法通知系统作业完成
            onHomeworkFinish();

            this.playLocalAudio('btn');
        })
    }

    leftMove() {
        this._cantouch = false;
        const len = this.pic1.parent.width;
        cc.tween(this.pic1)
            .to(1, { x: this.pic1.baseX }, { easing: 'cubicInOut' })
            .start();

        cc.tween(this.pic2)
            .to(1, { x: this.pic2.baseX }, { easing: 'cubicInOut' })
            .call(() => {
                this._cantouch = true;
            })
            .start();
    }

    rightMove() {
        this._cantouch = false;
        const len = this.pic1.parent.width;
        cc.tween(this.pic1)
            .to(1, { x: this.pic1.baseX - len }, { easing: 'cubicInOut' })
            .start();

        cc.tween(this.pic2)
            .to(1, { x: this.pic2.baseX - len }, { easing: 'cubicInOut' })
            .call(() => {
                this._cantouch = true;
            })
            .start();
    }
    // update (dt) {},


    initListener() {

    }

    playLocalAudio(audioName) {
        const audio = cc.find(`Canvas/res/audio/${audioName}`).getComponent(cc.AudioSource);
        return new Promise((resolve, reject) => {
            const id = cc.audioEngine.playEffect(audio.clip, false);
            cc.audioEngine.setFinishCallback(id, () => {
                resolve(id);
            });
        })
    }
}
