import {Component, EventEmitter, Input, OnDestroy, OnChanges, OnInit, Output, ApplicationRef, ChangeDetectorRef} from '@angular/core';

import { Star, Page, Kind, Option, East10 } from './east10';
import { JsonPipe } from '@angular/common';

@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.scss']
})

export class FormComponent implements OnInit, OnChanges, OnDestroy {


  // 储存数据用
  saveKey = "EAST-10";
  // 储存对象
  item;


  @Output()
  update = new EventEmitter();
  constructor(private appRef: ApplicationRef, private changeDetectorRef: ChangeDetectorRef) {

  }

  ngOnInit() {

    //this.item = new Course();
    this.item = new East10();

    // 获取存储的数据
    (<any>window).courseware.getData((data) => {

      if (data) {
        this.item = data;
        this.preData();
      }
      //console.log(data);
      this.init();
      this.changeDetectorRef.markForCheck();
      this.changeDetectorRef.detectChanges();
      this.refresh();

    }, this.saveKey);
    //console.log(this.item);
  }

  ngOnChanges() {

  }

  ngOnDestroy() {
  }


  init() {
    if(!this.item){
      this.item = new East10();
    }
  }



  initData() {
  }



  onImageUploadSuccess(e, item,  key) {
    item[key] = e.url;
    this.save();
  }
  onAudioUploadSuccess(e, item, key) {
    item[key] = e.url;
    this.save();
  }



  radioClick(it, radioValue) {
    it.radioValue = radioValue;

    this.saveItem();
  }

  clickCheckBox() {
    this.saveItem();
  }


  saveItem() {
    this.save();
  }

  save() {
    (<any>window).courseware.setData(this.item, null, this.saveKey);
    this.refresh();
    console.log('this.item = ' + JSON.stringify(this.item));
  }


  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }

  preData(){
    this.item.options = null;
  }

  randomChar() {
    var x = "0123456789qwertyuioplkjhgfdsazxcvbnm";
    var tmp = "";
    var timestamp = new Date().getTime();
    for (var i = 0; i < 6; i++) {
      tmp += x.charAt(Math.ceil(Math.random() * 100000000) % x.length);
    }

    return timestamp + tmp;
  }

  addStar(){
    let star = new Star();
    star.id = this.randomChar();
    this.item.stars.push(star);
    this.save();
  }

  delStar(idx){
    if (idx !== -1){
      this.item.stars.splice(idx, 1);
      this.save();
    }
  }

  addPage(){
    let page = new Page();
    page.id = this.randomChar();
    this.item.pages.push(page);
    this.save();
  }

  delPage(idx){
    if (idx !== -1){
      this.item.pages.splice(idx, 1);
      this.save();
    }
  }

  addKind(){
    let kind = new Kind();
    kind.options = new Array<Option>(); 
    kind.is_disturb = false;
    kind.is_text = true;
    kind.kind_type = "0";
    kind.id = this.randomChar();
    this.item.kinds.push(kind);
    this.save();
  }

  delKind(idx){
    if (idx !== -1){
      this.item.kinds.splice(idx, 1);;
      this.save();
    }
  }

  addOption(kind_id){
    if (kind_id < 0 || kind_id >= this.item.kinds.length){
      return;
    }

    let option = new Option();
    option.is_text = true;
    if (!this.item.kinds[kind_id].options)
      this.item.kinds[kind_id].options = new Array<Option>(); 

    this.item.kinds[kind_id].options.push(option);
    this.save();
  }

  delOption(kind_id, idx){
    if (kind_id < 0 || kind_id >= this.item.kinds.length)
      return;

      if (idx !== -1){
      this.item.kinds[kind_id].options.splice(idx, 1);
      this.save();
    }
  }

  setStarID(e, item){
    item.star_id = e;
    this.save();
  }

  setPageID(e, item){
    item.page_id = e;
    this.save();
  }

  setKindID(e, item){
    item.kind_id = e;
    this.save();
  }

}

