// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html
import pg from "./pg";
import user from "./model/user";
const {ccclass, property} = cc._decorator;

@ccclass
export default class ChangeItemAnimation extends cc.Component {
    armatureDisplay: dragonBones.ArmatureDisplay;
    animNode: cc.Node;

    @property(cc.AudioClip)
    starPopAudio: cc.AudioClip = null;

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    start () {
        this.animNode = cc.find('levelup', this.node);
        if (!this.animNode) {
           return;
        }
        this.armatureDisplay = this.animNode.getComponent(dragonBones.ArmatureDisplay);
        this.armatureDisplay.addEventListener(dragonBones.EventObject.COMPLETE, this.OnCallAnimationPlayComplete, this);
         // @ts-ignore
         this.node.changeFurniture = this.changeFurniture.bind(this)
    }
    changeFurniture (data) {
        pg.view.setNetImg(this.node, data.itemImage, false).then(({w, h}) => {
            console.log({w, h})
            let {x, y, width, height} = this.node;
            if (data.rect) {
                x = data.rect.x;
                y = data.rect.y;
                width = data.rect.width;
                height = data.rect.height;
                this.node.x = x;
                this.node.y = y;
                this.node.width = width;
                this.node.height = height;
                this.node.active = false;
                setTimeout(() => {
                    this.node.active = true;
                })
            }
            user.updateFurniture(data, {
                x, y, width, height
            });
        });
        if (!this.animNode) {
            return;
         }
        this.animNode.active = true;
        cc.audioEngine.play(this.starPopAudio, false, 1);
        this.armatureDisplay.playAnimation("newAnimation", 1);
        
    }
    OnCallAnimationPlayComplete () {
        console.log(1111);
        this.animNode.active = false;
    }
    // update (dt) {}
}
