import HouseItem from "./houseItem";
import { ITEM_TYPE } from "../config/config";
import user from "./user";
import shop from "./shop";
import pg from "../pg";
class House {
    public _list: Array<HouseItem>
    constructor() {
        this._list = [];
    }
    parse(list: any) {
        if (!list) return;
        this._list = list.map(li => {
            // console.log(li);
            return new HouseItem(li);
        })
    }

    get list() {
        return this._list;
    }
    getListByKind(kind: string) {
        return this._list.filter(li => li.kind == kind).map(li => {
            return {...li, current: user.isCurrentFurniture(li.id, li.kind) }
        })
    }
    has(item_id) {
        return this._list.findIndex(it => it.id == item_id) > -1;
    }
    setFurnitureItem(node, id, rect = null) {
        // const item = this._list.find(li => li.id == id);
        // const item = shop.getListByType(ITEM_TYPE.HOUSE).find(li => li.id == id);

        const item = shop._list.find(li => li.id == id);

        // if (!item) {
        //     item = this._list.find(li => {
        //         return li.defaultId == id
        //     });;
        // }
        if (!item) {
            return;
        }
        pg.view.setNetImg(node, item.itemImage, true).then(() => {
            node.active = true;
            if (!rect) {
                rect = item.rect;
            }
            node.x = rect.x;
            node.y = rect.y;
            node.width = rect.width;
            node.height = rect.height;
        });
        
    }
}
const house = new House();
export default house;
