import Item from "./item"
import HouseItem from "./houseItem"
import house from "./house";
import dress from "./dress";
import { ITEM_TYPE } from "../config/config";
class Shop {
    public _list: Array<Item>
    constructor() {
        this._list = [];
    }
    parse(list: any) {
        if (!list) return;
        this._list = list.map(li => {
            if (li.type == 2) {
                return new HouseItem(li);
            }
            return new Item(li);
        })
    }

    get list() {
        return this._list.filter(li => ![20,21,22,23,24,25,26,27,28,29,30].includes(li.id));
    }
    getListByType(type: number) {
        const myDress = dress.list.map(it => it.id).filter(id => !!id)
        return this._list.filter(li => {
            return li.type == type && ![20,21,22,23,24,25,26,27,28,29,30].includes(li.id);
        }).map(li => {
            if (li.type == ITEM_TYPE.FOOD) {
                return {...li, num: (house.has(li.id) ? 1 : 0)}
            }
            if (li.type == ITEM_TYPE.CLOTHES) {
                return {...li, num: (myDress.includes(li.id) ? 1 : 0)}
            }
            return li;
           
        });
    }
}
const shop = new Shop();
export default shop;
