import { LEVEL } from "../config/config";
import Api from "../net/api";

class User {
    public name: string;
    public coin: number;
    public level: number;
    public growth: number;//当前成长值
    public growthLevel: number;
    public growthDaily: number;
    public growthDailyMax: number;
    public eatTime: number;
    // public useFurniture: Array<number>;
    public useClothes: number;
    public myFurniture: any;
    public myDress: any;

    public mood: number;//0开心  1不开心

    private dataReadyCallback = null
    constructor() {

    }
    parse(data) {
        this.name = data.name;
        this.coin = data.coin;
        this.level = data.level;
        this.growth = data.growth;
        this.growthLevel = data.growthLevel;
        this.growthDaily = data.growthDaily;
        this.growthDailyMax = data.growthDailyMax;
        this.eatTime = data.eatTime;
        // this.useFurniture = data.useFurniture;
        this.myFurniture = data.myFurniture;
        this.useClothes = data.useClothes;
        this.mood = data.mood;
        if (this.dataReadyCallback && this.dataReadyCallback.call) {
            this.dataReadyCallback(this)
        }
    }
    setDataReadyCallback(callback) {
        this.dataReadyCallback = callback
    }
    isDailyMax() {
        return this.growthDailyMax >= this.growthDaily
    }
    addGrowth(val) {
        this.growth += val;
        this.growthDaily += val;
        user.mood = 0;
    }
    useCoin(val) {
        this.coin -= val;
    }
    isCurrentDress(id) {
        return this.useClothes == id;
    }
    isCurrentFurniture(id, kind) {
        if (this.myFurniture.furniture) {
            return this.myFurniture.furniture[kind].id == id
        }
        return false;
    }

    hasThisDress(id) {
        return false
    }

    updateFurniture(data, rect) {
        this.myFurniture.furniture[data.kind] = {
            ...this.myFurniture.furniture[data.kind],
            id: data.id,
            rect
        }
        Api.updateUserHouse(data, rect);
    }
    updateDress(id) {
        Api.updateUserDress(id);
    }
    // //当前等级成长值最大值
    // public get growthLevel(): number {
    //     let max = 1;
    //     for (let i = 1; i < 100; i++) {
    //         let val = LEVEL[`level_${i}`].growth;
    //         if (this.growth < val) {
    //             max = val
    //             break;
    //         }
    //     }
    //     return max
    // }
}
let user = new User();
export default user;

// 游戏 ： {
//     角色信息：{
//       名字
//       心情：开心|饥饿
//       金币
//       等级
//       成长值
//       每日成长值
//       每日成长值上限
//       上次吃东西的时间
//       当前使用的家具：[书柜，地毯，，，，，]对应的物品id
//       当前穿戴的服饰：[衣服，裤子，，，] 对应的物品id
//     }
//     仓库：[
//        {
//          物品id
//          物品类型
//          物品数量
//        }，
//        {
//          物品id
//          物品类型
//          物品数量
//        }
//      ]
//     商城信息：[
//        {
//          物品id
//          物品类型
//         名字
//         价格
//         特价
//         等级限制
//        }，
//      ]
//     常量：{
//       物品列表：[
//          物品id
//          物品类型
//          名字
//          图片
//       ]
//       等级经验表：{
//         等级
//         所需成长值
//         每日成长上限
//       }
//     }
//   }