import pg from "../pg";
import { ITEMS, USER } from "../config/config"
import user from "../model/user";
import kitchen from "../model/kitchen";
import dress from "../model/dress";
import shop from "../model/shop";
import house from "../model/house";
//获取信息，购买物品，使用物品（吃东西），穿戴衣服/更换家具

class Api {
    static askUser() {
        return new Promise((resolve, reject) => {
            console.log(`[askUser] ${ globalThis.____GAME_ENV____.baseUrl}pets/v2/info`)
            pg.http.send("GET", `${ globalThis.____GAME_ENV____.baseUrl}pets/v3/info`, null).then((userInfo: any) => {
                // let userInfo = USER;
                try{
                    const shopItemMap = {};
                    userInfo.shop_items.forEach(item => {
                        shopItemMap[item.id] = item;
                    });
                    shop.parse(userInfo.shop_items);
                    const mood = (Date.now() - userInfo.status.eat.time) > 4 * 60 * 60 * 1000 ? 1: 0; // 4 hours
                    const info = {
                        name: userInfo.name,
                        coin: userInfo.coins,
                        level: userInfo.level,
                        eatTime: userInfo.status.eat.time,
                        // useFurniture: userInfo.furniture,
                        myFurniture: userInfo.furniture,
                        useClothes: userInfo.dress.id,
                        growth: userInfo.current_exp,
                        growthLevel: userInfo.need_exp,
                        mood
                    };
                    const my_dress_items = userInfo.my_dress_items.map(item => {
                        return shopItemMap[item.id];
                    });
                    // let kitchenInfo = ITEMS;
                    house.parse(userInfo.my_furniture_items);
                    kitchen.parse(userInfo.my_food_items);
                    dress.parse(my_dress_items);
                    console.log(info);
                    user.parse(info);
                    resolve('');
                } catch(e) {
                    reject(e)
                }
            }).catch(e => {
                reject(e)
            })
        });
    }
    static updateUserDress(params) {
        return new Promise((resolve, reject) => {
            pg.http.send("POST", `${ globalThis.____GAME_ENV____.baseUrl}pets/update/dress`, params).then((resp: any) => {
                try {
                    resolve(resp);
                } catch (e) {
                    reject(e)
                }
            }).catch(e => {
                reject(e)
            })
        }); 
    }
    static updateUserHouse(data, rect) {
        return new Promise((resolve, reject) => {
            pg.http.send("POST", `${ globalThis.____GAME_ENV____.baseUrl}pets/update/house`, {
                kind: data.kind,
                rect,
                id: data.id
            }).then((resp: any) => {
                // user.addGrowth(data.growthValue);
                // kitchen.use(data.id);
                try {
                    resolve(resp);
                } catch (e) {
                    reject(e)
                }
            }).catch(e => {
                reject(e)
            })
        }); 
    }
    static askUseItem(data) {
        return new Promise((resolve, reject) => {
            pg.http.send("POST", `${ globalThis.____GAME_ENV____.baseUrl}pets/use/item`, {item_id: data.id}).then((resp: any) => {
                // user.addGrowth(data.growthValue);
                // kitchen.use(data.id);
                try {
                    resolve(resp);
                } catch (e) {
                    reject(e)
                }
            }).catch(e => {
                reject(e)
            })
        });
    }
    static askBuyItem(data) {
        return new Promise((resolve, reject) => {
            data.id;
            data.type;
            pg.http.send("POST", `${ globalThis.____GAME_ENV____.baseUrl}pets/item/buy`, {item_id: data.id}).then((resp: any) => {
                // user.useCoin(data.cost * data.discount);
                // kitchen.buy(data.id);
                try {
                    resolve(resp);
                } catch (e) {
                    reject(e)
                }

            }).catch(e => {
                reject(e)
            })
        });
    }
}
export default Api;