// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const {ccclass, property} = cc._decorator;
import user from "./model/user";
import dress from "./model/dress";
import pg from "./pg";
@ccclass
export default class PengPeng extends cc.Component {
    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    start () {
        console.log('pengpeng start')
        user.setDataReadyCallback(this.dataReady);
        const walkNode = pg.view.find(this.node, "walk")
        const eatNode = pg.view.find(this.node, "eat");
        window.walk = walkNode
        window.eat = eatNode
        window.pp = this;
        pg.view.touchOn(walkNode, this.onTouchElephent, this);
        const btnClose = pg.view.find(this.node, "panel_info/btn_close");
        pg.view.touchOn(btnClose, this.onTouchPanel, this);

        // cache 
        const walkDragonDisplay = walkNode.getComponent(dragonBones.ArmatureDisplay);
        const eatDragonDisplay = eatNode.getComponent(dragonBones.ArmatureDisplay);
        const walkAtlasAsset = walkDragonDisplay.dragonAtlasAsset;
        const walkAsset = walkDragonDisplay.dragonAsset;
        const walkArmatureName = walkDragonDisplay.armatureName;

        const eatAtlasAsset = eatDragonDisplay.dragonAtlasAsset;
        const eatAsset = eatDragonDisplay.dragonAsset;
        const eatArmatureName = eatDragonDisplay.armatureName;

        
        

        dress.defaultSkin.meta_value.walk.tex_png = null;
        dress.defaultSkin.meta_value.walk.ske_json = walkAsset
        dress.defaultSkin.meta_value.walk.tex_json = walkAtlasAsset
        dress.defaultSkin.meta_value.eat.armature = walkArmatureName



        dress.defaultSkin.meta_value.eat.tex_png = null;
        dress.defaultSkin.meta_value.eat.ske_json = eatAsset
        dress.defaultSkin.meta_value.eat.tex_json = eatAtlasAsset
        dress.defaultSkin.meta_value.eat.armature = eatArmatureName
    }
    dataReady = () => {
        console.log('pengpeng dataReady');
        const item = dress.list.find(item => item.current)
        this.changeDress(item);
    }
    //打开提示面板
    onTouchElephent() {
        let panel_info = pg.view.find(this.node, "panel_info");
        if (panel_info.active) {
            this.onTouchPanel();
            return;
        }
        this.elephentState(user.mood == 0 ? 1 : 2);
        panel_info.active = true;
        //刷新内容
        let label_name = pg.view.find(panel_info, "label_name");
        pg.view.setString(label_name, user.name);
        let label_level = pg.view.find(panel_info, "label_level");
        pg.view.setString(label_level, `LV.${user.level ? user.level : 0 }`);

        let icon_happy = pg.view.find(panel_info, "icon_happy");
        let icon_hungry = pg.view.find(panel_info, "icon_hungry");
        icon_happy.active = user.mood == 0;
        icon_hungry.active = user.mood == 1;

        let percent = user.growth / user.growthLevel;
        let progress = pg.view.find(panel_info, "progress");
        progress.getComponent(cc.ProgressBar).progress = percent;
    }
    //关闭提示面板
    onTouchPanel() {
        let panel_info = pg.view.find(this.node, "panel_info");
        panel_info.active = false;
        this.elephentState(0);
    }
    //小象的动作管理。
    // private elephant: cc.Node;
    private _timer: number;
    elephentState(state) {
        switch (state) {
            case 0:
                this.elephantWalk();
                break;
            case 1:
                this.elephantHappy();
                break;
            case 2:
                this.elephantHungry();
                break;
            case 3:
                this.elephantEating();
                break;
        }
    }
    elephantWalk() {
        let walkAni = pg.view.find(this.node, "walk");
        const oriScaleX = walkAni.scaleX;
        let eatAni = pg.view.find(this.node, "eat");
        walkAni.active = true;
        eatAni.active = false;
        let db = pg.view.playDBAnimation(walkAni, "walking", 0);
        this.removeHungryAudio(db);
        cc.Tween.stopAllByTarget(this.node);
        walkAni.scaleX = oriScaleX;
        let moveX = 400;
        let moveY = 0;
        let winSize = cc.winSize;
        if (winSize.width / winSize.height < 16 / 9) {
            moveY = -(16 / 9 - winSize.width / winSize.height) * 750 / 2;
        }
        if (!this.node.active) {
            this.node.active = true;
            this.node.x = 0;
            this.node.y = moveY + Math.random() * 100;
        }
        cc.tween(this.node)
            .to(4, { x: moveX, y: moveY + Math.random() * 100 })
            .call(() => {
                walkAni.scaleX = -oriScaleX;
            })
            .to(4, { x: 0, y: moveY + Math.random() * 100 })
            .to(4, { x: -moveX, y: moveY + Math.random() * 100 })
            .call(() => {
                walkAni.scaleX = oriScaleX;
            })
            .to(4, { x: 0, y: moveY + Math.random() * 100 })
            .call(() => {
                this.elephentState(0);
            })
            .start();
    }
    elephantHappy() {
        let walkAni = pg.view.find(this.node, "walk");
        let eatAni = pg.view.find(this.node, "eat");
        walkAni.active = true;
        eatAni.active = false;
        let db = pg.view.playDBAnimation(walkAni, "happy", 0);
        this.removeHungryAudio(db);
        cc.Tween.stopAllByTarget(this.node);
        // walkAni.scaleX = 1;
    }
    elephantHungry() {
        let walkAni = pg.view.find(this.node, "walk");
        let eatAni = pg.view.find(this.node, "eat");
        walkAni.active = true;
        eatAni.active = false;
        this.playLocalAudio("hungry");
        let db: dragonBones.ArmatureDisplay = pg.view.playDBAnimation(walkAni, "hungry", 0);
        this.removeHungryAudio(db);
        this.addHungryAudio(db);
        cc.Tween.stopAllByTarget(this.node);
        // walkAni.scaleX = 1;
    }
    elephantEating() {
        let walkAni = pg.view.find(this.node, "walk");
        let eatAni = pg.view.find(this.node, "eat");
        walkAni.active = false;
        eatAni.active = true;
        cc.Tween.stopAllByTarget(this.node);
        pg.view.playDBAnimation(eatAni, "eating", 0);
        this.playLocalAudio("eating");
        setTimeout(() => {
            this.elephentState(0);
        }, 3500);
    }

    addHungryAudio(db: dragonBones.ArmatureDisplay) {
        db.addEventListener(dragonBones.EventObject.LOOP_COMPLETE, this.playHungryAudio, this)
    }
    removeHungryAudio(db: dragonBones.ArmatureDisplay) {
        db.removeEventListener(dragonBones.EventObject.LOOP_COMPLETE, this.playHungryAudio, this)
    }
    playHungryAudio() {
        this.playLocalAudio("hungry");
    }
    playLocalAudio(audioName) {
        const audio = cc.find(`Canvas/res/audio/${audioName}`).getComponent(cc.AudioSource);
        return new Promise((resolve, reject) => {
            const id = cc.audioEngine.playEffect(audio.clip, false);
            cc.audioEngine.setFinishCallback(id, () => {
                resolve(id);
            });
        })
    }


    changeDress(data) {
        console.log('changeDress1', dress)
        console.log('changeDress2', data)
        const promiseArray = [];
        const nodeNames = Object.keys(data.meta_value);
        for(let i = 0; i < nodeNames.length; i++) {
            const nodeName = nodeNames[i];
            const node = cc.find(nodeName, this.node)
            node.stopAllActions();
            window[nodeName] = node;
            if (node) {
                const proc = new Promise((resolve, reject) => {
                    const meta = data.meta_value[nodeName]
                    const dragonDisplay = node.getComponent(dragonBones.ArmatureDisplay);
                    const imageUrl = meta['tex_png'];
                    const skeUrl = meta['ske_json'];
                    const atlasUrl = meta['tex_json'];
                    const armatureName = meta['armature'];
                    const animationName = meta['animation'];
                    const properties = meta['node'];
                    const offset = meta['offset'];
                    
                    console.log(nodeName, armatureName,  node)

                    pg.load.loadAssets([
                        [imageUrl],
                        [atlasUrl, {ext: '.txt', type: dragonBones.DragonBonesAtlasAsset}], 
                        [skeUrl, {ext: '.txt', type: dragonBones.DragonBonesAsset}]
                    ]).then((assets: any[]) => {

                        const u1 = dragonDisplay.dragonAtlasAsset._uuid;
                        const u2 = dragonDisplay.dragonAsset._uuid;


                        // dragonDisplay.dragonAtlasAsset.destroy();
                        // dragonDisplay.dragonAsset.destroy();
                        
                        if (u1 && typeof u1 == 'string' && u1.startsWith('http')) {
                            console.log('release1', u1)
                            dragonDisplay.dragonAtlasAsset.destroy();
                            cc.assetManager.releaseAsset(dragonDisplay.dragonAtlasAsset.texture);
                            cc.assetManager.releaseAsset(u1);
                        }
                        if (u2 && typeof u2 == 'string' && u2.startsWith('http')) {
                            console.log('release1', u2)
                            dragonDisplay.dragonAsset.destroy();
                            cc.assetManager.releaseAsset(u2);
                        }

                        const currentArmature = dragonDisplay.armature()
                        if (currentArmature) {
                            currentArmature.dispose()
                        }
                        dragonDisplay.dragonAsset = null;
                        dragonDisplay.dragonAtlasAsset = null;
                        dragonDisplay.armatureName = "";

                        // dragonDisplay.playAnimation(null);


                        const [texture, atlasJson, dragonBonesJson ] = assets;
                        let atlas = atlasJson
                        if (atlasJson.constructor.name == 'cc_TextAsset') {
                            atlas = new dragonBones.DragonBonesAtlasAsset();
                            atlas._uuid = atlasUrl;
                            let atlasJsonStr = atlasJson.text;
                            atlas.atlasJson = atlasJsonStr;
                            atlas.texture = texture;
                        }
                        let asset = dragonBonesJson;
                        if (dragonBonesJson.constructor.name == 'cc_TextAsset') {
                            asset = new dragonBones.DragonBonesAsset();
                            asset._uuid = skeUrl;
                            asset.dragonBonesJson = dragonBonesJson.text;
                        }

                        dragonDisplay.dragonAtlasAsset = atlas;
                        dragonDisplay.dragonAsset = asset;
                        dragonDisplay.armatureName = armatureName;
                        const armature = dragonDisplay.armature()
                        // armature.animation.animationNames
                        console.log('animationName',node.name, armatureName, animationName, armature ? armature.animation.animationNames : [])
                        if (animationName) {
                            dragonDisplay.playAnimation(animationName, 0);
                        }
                        node.scaleX = 1;
                        node.scaleY = 1;
                        if (properties) {
                            Object.keys(properties).forEach(key => {
                                node[key] = properties[key];
                            })
                        }
                        if (offset) {
                            Object.keys(offset).forEach(key => {
                                node[key] += +offset[key];
                            })
                        }
                        resolve()

                    });
                    // cc.assetManager.loadRemote(imageUrl, (err: Error, texture: cc.Texture2D) => {
                    //     cc.assetManager.loadRemote(atlasUrl,{ext: '.txt'}, (error: Error, atlasJson: cc.TextAsset) => {
                    //         cc.assetManager.loadRemote(skeUrl, {ext: '.txt'},(error: Error, dragonBonesJson:cc.JsonAsset) => {
                    //             // console.log('texture', texture)
                    //             // console.log('atlasJson', atlasJson)
                    //             // console.log('dragonBonesJson', dragonBonesJson)
                    //             var atlas:any = new dragonBones.DragonBonesAtlasAsset();
                    //             atlas._uuid = atlasUrl;
                    //             atlas.atlasJson = atlasJson.text;
                    //             atlas.texture = texture;

                    //             var asset:any = new dragonBones.DragonBonesAsset();
                    //             asset._uuid = skeUrl;
                    //             asset.dragonBonesJson = dragonBonesJson;

                    //             console.log('set armatureName: ', armatureName)
                    //             dragonDisplay.armatureName = armatureName;
                    //             dragonDisplay.dragonAtlasAsset = atlas;
                    //             dragonDisplay.dragonAsset = asset;
                    //             // dragonDisplay.playAnimation('happy', 0);
                    //             resolve()
                    //         });
                    //     });
                    // });
                })
                promiseArray.push(proc);
            }
        }
        return Promise.all(promiseArray)
    }
    // update (dt) {}
}
