import { defaultData } from "../script/defaultData";

export class MyCocosSceneComponent extends cc.Component {

  // 生命周期 onLoad
  onLoad() {
    this.initSceneData();
    this.initSize();
  }

  _imageResList = null;
  _audioResList = null;
  _animaResList = null;
  initSceneData() {
    this._imageResList = [];
    this._audioResList = [];
    this._animaResList = [];
  }

  _designSize = null;  // 设计分辨率
  _frameSize = null;  // 屏幕分辨率
  _mapScaleMin = null;  // 场景中常用缩放（取大值）
  _mapScaleMax = null;  // 场景中常用缩放（取小值）
  _cocosScale = null;  // cocos 自缩放 （较少用到）
  initSize() {
    // 注意cc.winSize只有在适配后(修改fitHeight/fitWidth后)才能获取到正确的值,因此使用cc.getFrameSize()来获取初始的屏幕大小
    let screen_size = cc.view.getFrameSize().width / cc.view.getFrameSize().height
    let design_size = cc.Canvas.instance.designResolution.width / cc.Canvas.instance.designResolution.height
    let f = screen_size >= design_size
    cc.Canvas.instance.fitHeight = f
    cc.Canvas.instance.fitWidth = !f

    const frameSize = cc.view.getFrameSize();
    this._frameSize = frameSize;

    this._designSize = cc.view.getDesignResolutionSize();

    let sx = cc.winSize.width / frameSize.width;
    let sy = cc.winSize.height / frameSize.height;
    this._cocosScale = Math.min(sx, sy);

    sx = frameSize.width / this._designSize.width;
    sy = frameSize.height / this._designSize.height;
    this._mapScaleMin = Math.min(sx, sy) * this._cocosScale;
    this._mapScaleMax = Math.max(sx, sy) * this._cocosScale;

    cc.director['_scene'].width = frameSize.width;
    cc.director['_scene'].height = frameSize.height;
  }

  data = null;

  // 生命周期 start
  start() {
    if (window && (<any>window).courseware && (<any>window).courseware.getData) {
      (<any>window).courseware.getData((data) => {
        this.log('data:' + data);
        this.data = data || this.getDefaultData();
        this.data = JSON.parse(JSON.stringify(this.data));
        this.preloadItem();
      })
    } else {
      this.data = this.getDefaultData();
      this.preloadItem();
    }
  }

  getDefaultData() {
    return defaultData;
  }

  preloadItem() {
    this.addPreloadImage();
    this.addPreloadAudio();
    this.addPreloadAnima();
    this.preload();
  }

  addPreloadImage() {
  }

  addPreloadAudio() {
  }

  addPreloadAnima() {
  }

  preload() {
    const preloadArr = this._imageResList.concat(this._audioResList).concat(this._animaResList);
    cc.assetManager.loadAny(preloadArr, null, null, (err, data) => {

      if (window && window["air"]) {
        // window["air"].onCourseInScreen = (next) => {
        //   window["air"].isCourseInScreen = true;
        //   this.onLoadEnd();
        //   next();
        // };
        this.onLoadEnd().then(() => {
          window["air"].hideAirClassLoading();
        });
        
      } else {
        this.onLoadEnd();
      }

      cc.debug.setDisplayStats(false);
    });
  }

  log (str) {
    const node = cc.find('middleLayer');
    if(node){
      node.getComponent('middleLayer').log(str);
    }else{
      cc.log(str);
    }
  }

  onLoadEnd() {
    return new Promise((resolve,  reject) => {});
  }















  
  // ------------------------------------------------
  getSprNode(resName) {
    const sf = cc.find('Canvas/res/img/' + resName).getComponent(cc.Sprite).spriteFrame;
    const node = new cc.Node();
    node.addComponent(cc.Sprite).spriteFrame = sf;
    return node;
  }


  getSpriteFrimeByUrl(url, cb) {
    cc.loader.load({ url }, (err, img) => {
      const spriteFrame = new cc.SpriteFrame(img)
      if (cb) {
        cb(spriteFrame);
      }
    })
  }

  getSprNodeByUrl(url, cb) {
    const node = new cc.Node();
    const spr = node.addComponent(cc.Sprite);
    this.getSpriteFrimeByUrl(url, (sf) => {
      spr.spriteFrame = sf;
      if (cb) {
        cb(node);
      }
    })
  }

  playAudioByUrl(audio_url, cb = null) {
    if (audio_url) {
      cc.assetManager.loadRemote(audio_url, (err, audioClip: cc.AudioClip) => {
        const audioId = cc.audioEngine.play(audioClip, false, 0.8);
        if (cb) {
          cc.audioEngine.setFinishCallback(audioId, () => {
            cb();
          });
        }
      });
    }
  }
}