const { ccclass, property } = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {
    @property(cc.Node)
    item: cc.Node = null;

    @property
    items: any = null;

    @property
    list: Array<any> = [];

    @property
    updateItem: any = null;

    @property
    target: any = null;

    @property
    addNum: number = 1;

    @property
    selector: any = null;

    flush() {
        //执行一次更新
        this._updateScrollView();
    }

    onLoad() {

    }
    _updateScrollView() {
        //如果有性能压力改成 顺序加载，并且在关闭的时候能自动检测停止加载
        //在界面下方的所有节点自动的显示效果是隐藏效果。
        let view = this.node.getChildByName("view");
        let content = view.getChildByName("content");
        //后面改成动态判断内部节点的方式而不是暴力移除
        content.removeAllChildren();
        let addNum = this.addNum || 1;
        let list = this.list;
        let items = this.items;
        if (!items || items.length == 0) items = [this.item];
        for (let i = 0; i < list.length; i += addNum) {
            let datas = [list[i]];
            for (let m = 1; m < addNum; m++) {
                datas.push(list[i + m]);
            }
            let item = this._selectorCall(items, datas);
            let itemClone = cc.instantiate(item);
            itemClone.x = 0;
            itemClone.y = 0;
            content.addChild(itemClone);
            itemClone.active = true;
            this._updateItemCall(itemClone, datas);
        }
    }
    _updateItemCall(itemClone, datas) {
        this.updateItem && this.updateItem.call(this.target, itemClone, datas);
    }
    _selectorCall(items, datas) {
        return items[0];
        if (!this.selector) return items[0];
        return this.selector(items, datas);
    }
}
