// Learn cc.Class:
//  - https://docs.cocos.com/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

cc.Class({
    extends: cc.Component,

    properties: {
        designWidth: {
            default: 1280,
            type: cc.Integer
        },
        designHeight: {
            default: 720,
            type: cc.Integer
        },
        relativeNode: {
            default: null,
            type: cc.Node,
            tooltip: '设置相对节点'
        },
        relativeX: {
            default: 0,
            type: cc.Integer,
            tooltip: '设置相对节点的X偏移量'
        },
        relativeY: {
            default: 0,
            type: cc.Integer,
            tooltip: '设置相对节点的Y偏移量'
        },
        // foo: {
        //     // ATTRIBUTES:
        //     default: null,        // The default value will be used only when the component attaching
        //                           // to a node for the first time
        //     type: cc.SpriteFrame, // optional, default is typeof default
        //     serializable: true,   // optional, default is true
        // },
        // bar: {
        //     get () {
        //         return this._bar;
        //     },
        //     set (value) {
        //         this._bar = value;
        //     }
        // },
    },

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {},

    start () {
        cc.view._frameSize
        cc.view._devicePixelRatio
        window.aaa = this
        this.setScale();
        // this.setPosition();
    },
    
    setScale() {
        const {width: designWidth, height: designHeight} = cc.view.getDesignResolutionSize()
        if (!this.designWidth) {
            this.designWidth = designWidth
        }
        if (!this.designHeight) {
            this.designHeight = designHeight
        }
        let {width: viewWidth, height: wiewHeight} = cc.view.getFrameSize();
        const ration = cc.view.getDevicePixelRatio();
        viewWidth = viewWidth * ration;
        wiewHeight = wiewHeight * ration;
        const viewRatio = viewWidth / wiewHeight;
        const designRatio = this.designWidth / this.designHeight;
        let containerScale = 1;
        if (designRatio > viewRatio) {
            // base width
            containerScale = viewWidth / this.designWidth; 
            console.log('base w', containerScale);
        } else {
            // base height
            containerScale = wiewHeight / this.designHeight; 
            console.log('base h', containerScale);
        }
        // console.log(cc.winSize.width , viewWidth);
        // let sx = cc.winSize.width / viewWidth;
		// let sy = cc.winSize.height / wiewHeight;
        // console.log(sx,sy);
		let cocosScale = Math.min(cc.view._scaleX, cc.view._scaleY);

        this.node.width = this.designWidth;
        this.node.height = this.designHeight;
        this.node.x = 0;
        this.node.y = 0;
        
        this.node.scale = containerScale / cocosScale;

    },
    setPosition() {
        const canvas = cc.find('Canvas');
        if (!this.relativeNode) {
            this.relativeNode = this.node.parent
        }
        const worldPos = canvas.convertToWorldSpaceAR(cc.v2(this.relativeNode.x , this.relativeNode.y));
        console.log(1, worldPos);
        // const wx = this.relativeNode.width * (1 - this.relativeNode.anchorX) - 
        const wx =  worldPos.x - this.relativeNode.width
        // const wy = this.relativeNode.height * (this.relativeNode.anchorY - 1) + worldPos.y
        const wy = worldPos.y - this.relativeNode.height
        const nodePos = canvas.convertToWorldSpaceAR(cc.v2(this.node.x  , this.node.y));
        console.log(2, nodePos);
        // const nx = this.node.width * (1 - this.node.anchorX) - nodePos.x
        // const ny = this.node.height * (this.node.anchorY - 1) + nodePos.y
        const nx = this.node.width * (1 - this.node.anchorX) - nodePos.x;
        const ny = nodePos.y - this.node.height * (1 - this.node.anchorY) ;

        // const relaX = worldPos.x - nodePos.x;
        // const relaY = worldPos.y - nodePos.y;

        const relaX = (wx - nx) * this.node.scale;
        const relaY = (wy - ny) * this.node.scale;

        this.node.x = relaX + this.relativeX;
        this.node.y = relaY + this.relativeY;
    }

    // update (dt) {},
});
