// Learn cc.Class:
//  - https://docs.cocos.com/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html
const ImageMode = cc.Enum({
    NONE: 1,
    FILL: 2,
    CONTAIN: 3,
    COVER: 4
});
cc.Class({
    extends: cc.Component,

    properties: {
        image: {
            default: null,
            type: cc.Sprite
        },
        displayMode: {
            default: ImageMode.NONE,
            type: ImageMode
        },
        offsetX: {
            default: 0,
            type: cc.Integer,
        },
        offsetY: {
            default: 0,
            type: cc.Integer,
        },
        // foo: {
        //     // ATTRIBUTES:
        //     default: null,        // The default value will be used only when the component attaching
        //                           // to a node for the first time
        //     type: cc.SpriteFrame, // optional, default is typeof default
        //     serializable: true,   // optional, default is true
        // },
        // bar: {
        //     get () {
        //         return this._bar;
        //     },
        //     set (value) {
        //         this._bar = value;
        //     }
        // },
    },

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {},

    start () {
        if (!this.image) {
            this.image = this.node.getComponent(cc.Sprite)
        }
        if (!this.image) {
            return;
        }
        if (this.displayMode === ImageMode.FILL) {
            this.node.width = this.node.parent.width;
            this.node.height = this.node.parent.height;
        }
        if (this.displayMode === ImageMode.CONTAIN) {
            const scale = this.calcMinScale();
            this.node.x += this.offsetX;
            this.node.y += this.offsetY;
            this.node.scale = scale;
        }
        if (this.displayMode === ImageMode.COVER) {
            const scale = this.calcMaxScale();
            this.node.x += this.offsetX;
            this.node.y += this.offsetY;
            this.node.scale = scale;
        }
    },
    calcMinScale() {
        const {width: designWidth, height: designHeight} = this.node;
        const {width: viewWidth, height: wiewHeight} = this.node.parent;
        const viewRatio = viewWidth / wiewHeight;
        const designRatio = designWidth / designHeight;
        let containerScale = 1;
        if (designRatio > viewRatio) {
            // base width
            containerScale = viewWidth / designWidth; 
            console.log('base w', containerScale);
        } else {
            // base height
            containerScale = wiewHeight / designHeight; 
            console.log('base h', containerScale);
        }

        this.node.width = designWidth;
        this.node.height = designHeight;
        return containerScale
        
    },
    calcMaxScale() {
        const {width: designWidth, height: designHeight} = this.node;
        const {width: viewWidth, height: wiewHeight} = this.node.parent;
        const viewRatio = viewWidth / wiewHeight;
        const designRatio = designWidth / designHeight;
        let containerScale = 1;
        if (designRatio > viewRatio) {
            containerScale = wiewHeight / designHeight; 
            console.log('base h', containerScale);
        } else {
            containerScale = viewWidth / designWidth; 
            console.log('base w', containerScale);
        }

        this.node.width = designWidth;
        this.node.height = designHeight;
        return containerScale
    }
    // update (dt) {},
});
