import { Component, OnDestroy, OnChanges, OnInit, ApplicationRef, ChangeDetectorRef, ViewChild, ElementRef } from '@angular/core';
import { ComponentBase } from './ComponentBase';
import { MetaFormCreator } from './mataFormCreator';

@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent extends ComponentBase implements OnInit, OnChanges, OnDestroy {
  // 储存数据用
  saveKey = "extreme_skiing";

  item = {
    title: "急速滑雪",
    questionText: "雪地里有许多不同的指示牌，运动员要选择哪一个呢？亲爱的小玩家，请你认真听游戏指令，帮助运动员选择正确的指示牌吧！游戏结束后，根据收集到的指示牌数量，你将获得相应的能量石奖励哟！开始挑战吧！",
    questionTextAudio: "http://staging-teach.cdn.ireadabc.com/c3b69ad3d51385eac7d4195773ef59f7_l.mp3",
    questions: [],
    bgAduio: "",
    bgAduioName: "",
    audioName: ""
  };

  isVisible = false;
  deleteTitle = "是否删除题目";
  deleteCallback = function () { };
  openDelete(title, callback) {
    this.deleteCallback = callback;
    this.deleteTitle = title;
    this.isVisible = true;
  }
  handleCancel() {
    this.isVisible = false;
  }
  handleOk() {
    this.deleteCallback && this.deleteCallback();
    this.handleCancel();
  }
  init(): void {
    console.log(new MetaFormCreator().create());
  }

  removeoption(i, j) {
    this.openDelete("确定删除选项？", () => {
      this.item.questions[i].options.splice(j, 1);
      this.save();
    })
  }
  copyoption(i, j) {
    let data = this.item.questions[i].options[j];
    this.item.questions[i].options.push(JSON.parse(JSON.stringify(data)));
    this.save();
  }

  addoption(i) {
    this.item.questions[i].options.push({
      type: "txt",
      image: "",
      audio: "",
      text: "",
      time: "",
      right: false
    });
    this.save();
  }

  removequestion(idx) {
    this.openDelete("确定删除题目？", () => {
      this.item.questions.splice(idx, 1);
      this.save();
    })
  }

  addquestion() {
    this.item.questions.push({
      options: [],
      type: "",
      questionAudio: "",
      audioName: "",
    });
    this.save();
  }
  ngChange(i, j) {
    this.save();
  }

  deleteBgAudio() {
    this.item.bgAduio = "";
    this.item.bgAduioName = "";
    this.save();
  }
}