import { Component, OnDestroy, OnChanges, OnInit, ApplicationRef, ChangeDetectorRef, ViewChild, ElementRef } from '@angular/core';
import { ComponentBase } from './ComponentBase';
import { MetaFormCreator } from './mataFormCreator';

@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent extends ComponentBase implements OnInit, OnChanges, OnDestroy {
  // 储存数据用
  saveKey = "extreme_skiing";

  item = {
    title: "急速滑雪",
    questionText: "可恶的小偷将魔法卡牌藏在热气球里，准备偷走！快来夺回魔法卡牌吧！只要击落热气球，魔法卡牌就会掉落下来。请仔细观察魔法卡牌，并大声说出魔法咒语。魔法咒语正确，你将获得该张魔法卡牌。游戏结束后，根据获得的魔法卡牌数量，你将获得相应的能量石奖励！开始挑战吧！",
    questionTextAudio: "http://staging-teach.cdn.ireadabc.com/d60710f8580f77d494a6ab95d5cc46c5.mp3",
    questions: [],
    audioName: ""
  };

  isVisible = false;
  deleteTitle = "是否删除题目";
  deleteCallback = function () { };
  openDelete(title, callback) {
    this.deleteCallback = callback;
    this.deleteTitle = title;
    this.isVisible = true;
  }
  handleCancel() {
    this.isVisible = false;
  }
  handleOk() {
    this.deleteCallback && this.deleteCallback();
    this.handleCancel();
  }
  init(): void {
    console.log(new MetaFormCreator().create());
  }

  removeoption(i, j) {
    this.openDelete("确定删除选项？", () => {
      this.item.questions[i].options.splice(j, 1);
      this.save();
    })
  }
  copyoption(i, j) {
    let data = this.item.questions[i].options[j];
    this.item.questions[i].options.push(JSON.parse(JSON.stringify(data)));
    this.save();
  }

  addoption(i) {
    this.item.questions[i].options.push({
      type: "",
      image: "",
      audio: "",
      text: "",
      time: "",
      right: false
    });
    this.save();
  }

  removequestion(idx) {
    this.openDelete("确定删除题目？", () => {
      this.item.questions.splice(idx, 1);
      this.save();
    })
  }

  addquestion() {
    this.item.questions.push({
      options: [],
      type: ""
    });
    this.save();
  }
  ngChange(i, j) {
    this.save();
  }
}