export enum FISH_OUT {
    RUNNING,
    TOUCH,
    CATCH,
    ESCAP,
    OUT
}
export class Fish {
    public isOut: number;
    public node: cc.Node;
    public isLeft: boolean;//在左侧 向右运动
    constructor() {
        this.isOut = 0;
        this.isLeft = Math.random() < 0.5;
    }

}
export class Option {
    public type;
    public txt;
    public picUrl;
    public audioUrl;
    public right: boolean;
    public data;
    public id: number;
    public count: number;
    public time: number;
    public touchRight: boolean;
    public fish: Fish;
    constructor(data) {
        // this.id = id;
        this.data = data;
        this.type = data.type;
        this.txt = data.text;
        this.time = data.time;
        this.picUrl = data.image;
        this.audioUrl = data.audio;
        this.right = data.right;
        this.touchRight = false;
        this.fish = new Fish();
    }
}
export class Item {
    public page;
    public audio;
    public duration;
    public optionList;
    public checkMore: boolean;
    public rNum: number;
    constructor(data, page) {
        this.audio = data.questionAudio;
        this.duration = data.duration;
        let id = 0;

        this.optionList = data.options.map(o => {
            return new Option(o);
        })

        this.optionList.sort(function () {
            return (0.5 - Math.random());
        });
        this.rNum = 0;
        for (let i = 0; i < this.optionList.length; i++) {
            if (this.optionList[i].right) this.rNum++;
        }
        this.checkMore = this.rNum > 1;
        this.page = page;
    }
}
class Role {
    public score: number;
    public right: number;
    public error: number;
    public voices: Array<any>;
    constructor() {
        this.score = 0;
        this.error = 0;
        this.right = 0;
        this.voices = [];
    }
    addScore(score: number = 1) {
        this.score += score;
    }
    addError(score: number = 1) {
        this.error += score;
    }
    addRight() {
        this.right += 1;
    }
    addVoice(obj: any) {
        this.voices.push(obj);
    }
}
export class Player extends Role {
    constructor() {
        super();
    }
    reset() {
        this.score = 0;
        this.error = 0;
        this.right = 0;
        this.voices = [];
    }
}
export class Robot extends Role {
    constructor() {
        super();
    }
    reset() {
        this.score = 0;
        this.error = 0;
        this.right = 0;
        this.voices = [];
    }
}
export enum GAME_STATE {
    WAIT,
    RUNNING,
    OVER
}
export default class Game {
    private static ins: Game;
    public static getIns(): Game {
        if (!Game.ins) Game.ins = new Game();
        return Game.ins;
    }
    private data: any;
    private lists: Array<Item>
    public player: Player;
    public robot: Robot;
    public state: GAME_STATE;
    public total: number;

    constructor() {
        this.start = false;
        this.lists = [];
        this.player = new Player();
        this.robot = new Robot();
        this.state = GAME_STATE.WAIT;
    }
    get len() {
        return this.lists.length;
    }
    public singleGame: boolean;
    public question: { text, audio };
    public title: string;
    public questionText: string;
    public init(data) {
        this.singleGame = !data.onlineFlg;
        this.question = { text: data.questionText, audio: data.questionTextAudio };
        this.title = data.title;
        this.questionText = data.questionText;
        this.start = false;
        this.lists = [];
        this.data = data.questions;
    }
    public start: boolean;
    public page: number;
    reset() {
        this.player.reset();
        this.robot.reset();
        this.page = 1;
        this.start = true;
        this.lists = [];
        this.total = 0;
        for (let i = 0; i < this.data.length; i++) {
            let data = this.data[i];
            this.lists.push(new Item(data, i + 1));
        }
        this.state = GAME_STATE.WAIT;
    }
    checkSuccess(arr: Option[]) {
        let data = this.getCurrentPage();
        let options = data.optionList.concat();
        options.sort((A, B) => A.id - B.id)
        for (let i = 0; i < options.length; i++) {
            if (arr[i] && arr[i].id != options[i].id) {
                return false;
            }
        }
        return true;
    }


    getDataByPage(page): Item {
        return this.lists.filter(li => li.page == page)[0]
    }
    getCurrentPage(): Item {
        let page = this.page;
        return this.lists.filter(li => li.page == page)[0]
    }
    getTotalPageNum() {
        return this.lists.length;
    }
    getCurrentPageNum() {
        return this.page;
    }
    addPage() {
        this.page += 1;
    }
    get getTotla() {
        this.total = 0;
        this.lists.forEach((item) => {
            this.total += item.rNum;
        })
        return this.total;
    }
    get isOver() {
        return this.page > this.lists.length;
    }
}