const { removeDir, copyDir, fix2 } = require('./utils');
const compressing = require('compressing');
let fs = require('fs');

async function main() {
  await removeDir('./publish/play');
  await removeDir('./publish/form');

  await copyDir('../play/build/web-desktop', './publish/play');
  compressing.zip.uncompress('../form/publish/form.zip', './publish/form');

  const data = await fs.readFileSync('./index.html');
  await fs.writeFileSync('./publish/play/index.html', data);

  await removeDir('../play/build/web-desktop');


  const path = '../play/assets'
  let folderName = '';
  fs.readdirSync(path).find(fileName => {
    const st = fs.statSync(`${path}/${fileName}`);
    if (st.isDirectory()) {
      folderName = fileName;
    }
  });
  const metaPath = `${path}/${folderName}.meta`;
  const metaDataStr = fs.readFileSync(metaPath);
  const metaData = JSON.parse(metaDataStr);
  metaData.isBundle = true;
  metaData.isRemoteBundle = {
    ios: true,
    android: true
  };
  fs.writeFileSync(metaPath, JSON.stringify(metaData));
}

main();