import { Component, OnDestroy, OnChanges, OnInit, ApplicationRef, ChangeDetectorRef, ViewChild, ElementRef } from '@angular/core';
import { ComponentBase } from './ComponentBase';
import { MetaFormCreator } from './mataFormCreator';

@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent extends ComponentBase implements OnInit, OnChanges, OnDestroy {
  // 储存数据用
  saveKey = "dqq";

  item = {
    title: "",
    questionText: "",
    questionTextAudio: "",
    questions: []
  };

  init(): void {
    console.log(new MetaFormCreator().create());
  }

  removeoption(i, j) {
    this.item.questions[i].options.splice(j, 1);
    this.save();
  }

  addoption(i) {
    this.item.questions[i].options.push({
      type: "img",
      image: "", 
      audio: "", 
      text: "", 
    });
    this.save();
  }

  removequestion(i) {
    this.item.questions.splice(i, 1);
    this.save();
  }

  addquestion() {
    this.item.questions.push({
      options: []
    });
    this.save();
  }
}