
/* 

window.courseware.getData(callback,key);  //用于获取数据

window.air.hideAirClassLoading(key,data);  //页面加载完成时，必须调用此方法，用于隐藏遮罩层
 
*/


//对应模板的名称，这个可以不写，但是最好是能写上，同时开发多个模板的情况下如果不写这个，本地缓存可能会存在混乱
var key = "hw_020";

// 分别为一个字、两个字、三个字.... 的字体大小
const fontSizes = ["30vw", "23vw", "15vw", "10vw"];
// 默认数据
let textArr = ["A","B"];

function getRandom(index){
  const arr = [1, 2, 3];
  arr.splice(arr.indexOf(index), 1);
  const i = Math.ceil( Math.random() * 2 );
  return arr[i-1];
}

function getFontSize(txt) {
  return txt.length-1>3?3:txt.length-1;
}

$(function(){
  window.courseware.getData(function(data){
    //数据加载完，才算页面加载完成
    //获取数据
    if(data&&data.text){
      textArr = data.text.replace(/，/g, ",").split(",");
      const len = getFontSize(textArr[0]);
      $(".card").css("font-size", fontSizes[len]).html(textArr[0]);
    }
    //在页面加载、事件、动画等都初始化完成后，一定要记得调用此方法，否则模板将是不可用的
    window.air.hideAirClassLoading(key,data);
  },key); 

  var clickFlag = false;
  var bgRandom = 1;
  var fontIndex = 1;
  $(".bg").click(function (){
    if(clickFlag){
      return;
    }
    clickFlag = true;
    const realCard = $(".card");
    const cloneCard = realCard.clone(true).css({
      "position": "absolute",
      "top": realCard.position().y,
      "left": realCard.position().x,
    });
    $(this).append(cloneCard);
    cloneCard.on('animationend', function(e) {
      $(this).remove();
      clickFlag = false;
    }).addClass("moveout");
    
    bgRandom = getRandom(bgRandom);
    const len = getFontSize(textArr[fontIndex]);
    realCard.css("font-size", fontSizes[len]).html(textArr[fontIndex]);
    realCard.attr("class", `card card-bg-${bgRandom} pipo`);
    if(fontIndex>=textArr.length-1){
      fontIndex = 0;
    }else{
      fontIndex ++;
    }
  });
  $(".card").on('animationend', function(e) {
    $(this).removeClass("pipo");
  });
})