import pg from "../../scene/pg";

const { ccclass, property } = cc._decorator;

let win: any = window;
let courseware = win.courseware;
@ccclass
export default class LayerRecord extends cc.Component {
    private layout_record: cc.Node;
    onLoad() {
        this.layout_record = pg.view.find(this, 'layout_record')
        let AniNode = pg.view.find(this.layout_record, 'AniNode');
        AniNode.active = false;
        let btn_play = pg.view.find(this.layout_record, 'btn_play');
        btn_play.active = false;
        this.initEvent();
        pg.event.emit('layer_record_setting', {
            letter: 'test',
            targetTime: 10
        })
    }
    private letter: string;
    private targetTime: number;
    initEvent() {
        pg.event.on('layer_record_setting', (data) => {
            this.letter = data.letter
            this.targetTime = data.targetTime
        })
        let btn_record = pg.view.find(this.layout_record, 'btn_record');
        btn_record.on(cc.Node.EventType.TOUCH_START, this.onTouchRecord, this);
        btn_record.on(cc.Node.EventType.TOUCH_END, this.onTouchRecordEnd, this);
    }

    showVoiceWhite() {
        let voice_white = pg.view.find(this.layout_record, 'voice_white');
        cc.tween(voice_white).set({ scale: 1, opacity: 255 }).to(1, { scale: 1.5, opacity: 0 }).delay(0.5).union().repeatForever().start();
    }
    private startTime: number;
    showTimeStart() {
        if (!this.targetTime) return;
        let nowTime = new Date().getTime();
        this.startTime = nowTime;
    }
    showTimeUpdate() {
        if (!this.startTime) return;
        let nowTime = new Date().getTime();
        let subTime = (nowTime - this.startTime) / 1000;
        let percent = 1 - (subTime / this.targetTime);
        percent = Math.max(percent, 0)
        let record_time = pg.view.find(this.layout_record, 'record_time');
        record_time.getComponent(cc.Sprite).fillRange = percent;
        if (percent == 0) {
            this.showTimeEnd();
        }
    }
    showTimeEnd() {
        this.startTime = null;
        let record_time = pg.view.find(this.layout_record, 'record_time');
        record_time.getComponent(cc.Sprite).fillRange = 0;
    }


    protected update(dt: number): void {
        this.showTimeUpdate();
    }
    //按钮触发，使用的方法
    async onTouchRecord() {
        let AniNode = pg.view.find(this.layout_record, 'AniNode');
        AniNode.active = true;
        this.showTimeStart();

        cc.audioEngine.stopAllEffects();
        courseware && courseware.startTest(this.letter); //开始录音
    }
    async onTouchRecordEnd() {
        let AniNode = pg.view.find(this.layout_record, 'AniNode');
        AniNode.active = false;
        this.showTimeEnd();
        let testData = {
            "dtLastResponse": "2021-09-17 13:36:26:109",
            "refText": "I haven't found anything out about him yet.",
            "recordId": "6144295213f0a2200000ed93",
            "eof": 1,
            "result": {
                "pronunciation": 25,
                "resource_version": "3.1.0",
                "fluency": 60,
                "rhythm": 90,
                "kernel_version": "5.2.4",
                "overall": 25,//75
                "integrity": 100,
                "duration": "6.779",
                "rear_tone": "fall",
                "speed": 96,
            },
            "tokenId": "6144295408558b08dd000001",
            "applicationId": "154838659000009e"
        }
        if (!courseware) return this.recrodEnd(testData)
        courseware && courseware.stopTest((data) => {
            data = JSON.parse(data);
            this.recrodEnd(data);
        }); //结束录音
    }
    async recrodEnd(data) {
        let score = data.result.overall;
        pg.event.emit('layer_record_score', score);
    }
}
