import pg from "../../scene/pg";

const { ccclass, property } = cc._decorator;

let win: any = window;
let courseware = win.courseware;
@ccclass
export default class LayerRecord extends cc.Component {

    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = 'hello';

    // LIFE-CYCLE CALLBACKS:

    onLoad() { }

    start() {

    }



    //按钮触发，使用的方法
    async onTouchRecord() {
        let ske = pg.view.find(this.layout_speak, 'speak_ske');
        let btn_start = pg.view.find(this.layout_speak, 'btn_start');
        let btn_stop = pg.view.find(this.layout_speak, 'btn_stop');
        btn_start.active = false;
        btn_stop.active = true;
        ske.getComponent(dragonBones.ArmatureDisplay).timeScale = 1;
        cc.audioEngine.stopAllEffects();

        let end = pg.view.find(this, "end");
        let bg_tryagain = pg.view.find(end, "bg_tryagain")
        pg.view.visible(end, false);
        pg.view.visible(bg_tryagain, false);

        courseware && courseware.startTest(this.touchData.txt); //开始录音
    }
    async onTouchRecordEnd() {
        let ske = pg.view.find(this.layout_speak, 'speak_ske');
        let btn_start = pg.view.find(this.layout_speak, 'btn_start');
        let btn_stop = pg.view.find(this.layout_speak, 'btn_stop');
        pg.view.playDBAnimation(ske, 'newAnimation', 1);
        ske.getComponent(dragonBones.ArmatureDisplay).timeScale = 10000;
        btn_stop.active = false;
        btn_start.active = false;
        let testData = {
            "dtLastResponse": "2021-09-17 13:36:26:109",
            "refText": "I haven't found anything out about him yet.",
            "recordId": "6144295213f0a2200000ed93",
            "eof": 1,
            "result": {
                "pronunciation": 25,
                "resource_version": "3.1.0",
                "fluency": 60,
                "rhythm": 90,
                "kernel_version": "5.2.4",
                "overall": 25,//75
                "integrity": 100,
                "duration": "6.779",
                "rear_tone": "fall",
                "speed": 96,
            },
            "tokenId": "6144295408558b08dd000001",
            "applicationId": "154838659000009e"
        }
        if (!courseware) return this.recrodEnd(testData)
        // await pg.time.delay(5);
        courseware && courseware.stopTest((data) => {
            data = JSON.parse(data);
            this.recrodEnd(data);
        }); //结束录音
    }
    private tryData: Array<Option>;
    async recrodEnd(data) {
        Game.getIns().player.addVoice(data);
        let score = data.result.overall;
        if (score >= 80) {
            //提示成功
            this.updateTips(TIPS_STATE.GOOD);
            Game.getIns().player.addRight();
            this.touchFishs.push(this.touchData);
        } else {
            //提示失败
            if (this.tryData.some(td => td.id == this.touchData.id)) {
                this.updateTips(TIPS_STATE.COM);
                this.touchFishs.push(this.touchData);
            } else {
                this.updateTips(TIPS_STATE.TRY);
                this.tryData.push(this.touchData);
                this.viewFishs = this.viewFishs.filter(v => v.id != this.touchData.id);
            }
        }
        await pg.time.delay(3);
        this.updateTips(null);
        this.playCard(null);
        this.updateLayoutSpeak(true)
        this.touching = false;
    }

    // update (dt) {}
}
