import { asyncDelay, onHomeworkFinish } from "../script/util";
import { MyCocosSceneComponent } from "../script/MyCocosSceneComponent";
import pg from "./pg";

const { ccclass, property } = cc._decorator;

@ccclass
export default class SceneComponent extends MyCocosSceneComponent {

    addPreloadImage() {
        // TODO 根据自己的配置预加载图片资源
        this._imageResList.push({ url: this.data.pic_url });
        this._imageResList.push({ url: this.data.pic_url_2 });
    }

    addPreloadAudio() {
        // TODO 根据自己的配置预加载音频资源
        this._audioResList.push({ url: this.data.audio_url });
    }

    addPreloadAnima() {

    }

    async onLoadEnd() {
        // TODO 加载完成后的逻辑写在这里, 下面的代码仅供参考
        this.initData();
        this.initView();
        this.initListener();
    }

    _cantouch = null;
    initData() {
        // 所有全局变量 默认都是null 
        this._cantouch = true;
    }

    initView() {
        // pg.event.on('layer_right_show_excellent_end', () => {
        //     alert('test')
        // })
        // pg.event.emit('layer_right_show_excellent')
        // pg.event.on('layer_right_show_good_end', () => {
        //     alert('test')
        // })
        // pg.event.emit('layer_right_show_good')
        // pg.event.on('layer_right_show_tryagain_end', () => {
        //     alert('test')
        // })
        // pg.event.emit('layer_right_show_tryagain')

        // pg.event.emit('img_voice_play_voice_start')
        // setTimeout(() => {
        //     pg.event.emit('img_voice_play_voice_end')
        // }, 2000)
    }


    initListener() {

    }

    playLocalAudio(audioName) {
        const audio = cc.find(`Canvas/res/audio/${audioName}`).getComponent(cc.AudioSource);
        return new Promise((resolve, reject) => {
            const id = cc.audioEngine.playEffect(audio.clip, false);
            cc.audioEngine.setFinishCallback(id, () => {
                resolve(id);
            });
        })
    }
}
