// pg.event.emit('npc_voice_play_voice_start')
// pg.event.emit('npc_voice_play_voice_end')


import pg from "../../scene/pg_hy01_danci";

const { ccclass, property } = cc._decorator;

@ccclass
export default class LayerBack extends cc.Component {
    private btn_back: cc.Node;
    private img_npc_voice: cc.Node;
    onLoad() {
        this.initView();
        this.initEvent();
    }
    initView() {
        this.btn_back = pg.view.find(this, 'btn_back')
        this.img_npc_voice = pg.view.find(this, 'img_npc_voice')
    }
    initEvent() {
        pg.view.touchOn(this.btn_back, this.onTouchBack, this)

        pg.event.on('npc_voice_play_voice_start', () => {
            this.playVoiceStart();
        })
        pg.event.on('npc_voice_play_voice_end', () => {
            this.playVoiceEnd();
        })
    }
    private playVoiceCount: number;
    playVoiceStart() {
        if (this.playVoiceCount > 0) return;
        this.playVoiceCount = 0;
        this.schedule(this.playVoiceRunning, 0.3)
    }
    playVoiceRunning() {
        this.playVoiceCount++;
        let p1 = this.img_npc_voice.getChildByName('p1')
        let p2 = this.img_npc_voice.getChildByName('p2')
        let p3 = this.img_npc_voice.getChildByName('p3')
        p1.active = this.playVoiceCount % 3 == 0;
        p2.active = this.playVoiceCount % 3 == 1;
        p3.active = this.playVoiceCount % 3 == 2;
    }
    playVoiceEnd() {
        this.unschedule(this.playVoiceRunning)
        this.playVoiceCount = 0;
        let p1 = this.img_npc_voice.getChildByName('p1')
        let p2 = this.img_npc_voice.getChildByName('p2')
        let p3 = this.img_npc_voice.getChildByName('p3')
        p1.active = true;
        p2.active = false;
        p3.active = false;
    }
    onTouchBack() {
        const middleLayer = cc.find('middleLayer');
        const middleLayerComponent = middleLayer.getComponent('middleLayer');
        middleLayerComponent.exitGame();
    }
}

