import { Component, OnDestroy, OnChanges, OnInit, ApplicationRef, ChangeDetectorRef, ViewChild, ElementRef } from '@angular/core';
import { ComponentBase } from './ComponentBase';
import { MetaFormCreator } from './mataFormCreator';

@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent extends ComponentBase implements OnInit, OnChanges, OnDestroy {
  // 储存数据用
  saveKey = "hy01_danci";

  item = {
    recordFlag: false,
    title: "",
    questionText: "",
    questionTextAudio: "",
    questions: [{
      questionAudio: "",
      duration: 120,
      options: []
    }],
    bgAudio: "",
    bgAudioName: "",
    audioName: ""
  };

  isVisible = false;
  deleteTitle = "是否删除题目";
  deleteCallback = function () { };
  openDelete(title, callback) {
    this.deleteCallback = callback;
    this.deleteTitle = title;
    this.isVisible = true;
  }
  handleCancel() {
    this.isVisible = false;
  }
  handleOk() {
    this.deleteCallback && this.deleteCallback();
    this.handleCancel();
  }


  init(): void {
    console.log(new MetaFormCreator().create());
  }

  removeoption(i, j) {
    this.openDelete("确定删除选项？", () => {
      this.item.questions[i].options.splice(j, 1);
      this.save();
    })
  }
  copyOption(i, j) {
    let data = this.item.questions[i].options[j];
    this.item.questions[i].options.push(JSON.parse(JSON.stringify(data)));
    this.save();
  }

  addoption(i) {
    this.item.questions[i].options.push({
      type: "",
      image: "",
      audio: "",
      text: "",
      duration: '',
      content: '',
      right: false
    });
    this.save();
  }

  removequestion(i) {
    this.openDelete("确定删除题目？", () => {
      this.item.questions.splice(i, 1);
      this.save();
    })
  }

  addquestion() {
    this.item.questions.push({
      questionAudio: "",
      duration: 120,
      options: []
    });
    this.save();
  }

  deleteBgAudio() {
    this.item.bgAudio = "";
    this.item.bgAudioName = "";
    this.save();
  }
  ngChange(i, j) {
    this.save();
  }
}