/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { Platform } from '@angular/cdk/platform';
import { AfterViewInit, ChangeDetectorRef, EventEmitter, OnDestroy } from '@angular/core';
import { NgStyleInterface, NzConfigService, NzScrollService } from 'ng-zorro-antd/core';
import { NzAnchorLinkComponent } from './nz-anchor-link.component';
import * as ɵngcc0 from '@angular/core';
export declare class NzAnchorComponent implements OnDestroy, AfterViewInit {
    nzConfigService: NzConfigService;
    private scrollSrv;
    private doc;
    private cdr;
    private platform;
    private ink;
    nzAffix: boolean;
    nzShowInkInFixed: boolean;
    nzBounds: number;
    nzOffsetTop: number;
    private _offsetTop;
    nzTarget: string | Element;
    readonly nzClick: EventEmitter<string>;
    readonly nzScroll: EventEmitter<NzAnchorLinkComponent>;
    visible: boolean;
    wrapperStyle: NgStyleInterface;
    private links;
    private animating;
    private target;
    private scroll$;
    private destroyed;
    constructor(nzConfigService: NzConfigService, scrollSrv: NzScrollService, doc: any, cdr: ChangeDetectorRef, platform: Platform);
    registerLink(link: NzAnchorLinkComponent): void;
    unregisterLink(link: NzAnchorLinkComponent): void;
    private getTarget;
    ngAfterViewInit(): void;
    ngOnDestroy(): void;
    private registerScrollEvent;
    private removeListen;
    private getOffsetTop;
    handleScroll(): void;
    private clearActive;
    private handleActive;
    handleScrollTo(linkComp: NzAnchorLinkComponent): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzAnchorComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzAnchorComponent, "nz-anchor", ["nzAnchor"], {
    "nzAffix": "nzAffix";
    "nzOffsetTop": "nzOffsetTop";
    "nzTarget": "nzTarget";
    "nzShowInkInFixed": "nzShowInkInFixed";
    "nzBounds": "nzBounds";
}, {
    "nzClick": "nzClick";
    "nzScroll": "nzScroll";
}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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