/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { ContentObserver } from '@angular/cdk/observers';
import { AfterViewInit, ChangeDetectorRef, ElementRef, NgZone, OnChanges, OnDestroy, OnInit, Renderer2, SimpleChanges, TemplateRef } from '@angular/core';
import { NzConfigService } from 'ng-zorro-antd/core';
import * as ɵngcc0 from '@angular/core';
export declare type NzBadgeStatusType = 'success' | 'processing' | 'default' | 'error' | 'warning';
export declare class NzBadgeComponent implements OnInit, AfterViewInit, OnChanges, OnDestroy {
    nzConfigService: NzConfigService;
    private renderer;
    private elementRef;
    private contentObserver;
    private cdr;
    private ngZone;
    private destroy$;
    notWrapper: boolean;
    viewInit: boolean;
    maxNumberArray: string[];
    countArray: number[];
    countSingleArray: number[];
    colorArray: string[];
    presetColor: string | null;
    count: number;
    contentElement: ElementRef;
    nzShowZero: boolean;
    nzShowDot: boolean;
    nzDot: boolean;
    nzOverflowCount: number;
    nzText: string;
    nzColor: string;
    nzTitle: string;
    nzStyle: {
        [key: string]: string;
    };
    nzStatus: NzBadgeStatusType;
    nzCount: number | TemplateRef<void>;
    nzOffset: [number, number];
    checkContent(): void;
    readonly showSup: boolean;
    generateMaxNumberArray(): void;
    constructor(nzConfigService: NzConfigService, renderer: Renderer2, elementRef: ElementRef, contentObserver: ContentObserver, cdr: ChangeDetectorRef, ngZone: NgZone);
    ngOnInit(): void;
    ngAfterViewInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    ngOnDestroy(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzBadgeComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzBadgeComponent, "nz-badge", ["nzBadge"], {
    "nzShowZero": "nzShowZero";
    "nzShowDot": "nzShowDot";
    "nzDot": "nzDot";
    "nzOverflowCount": "nzOverflowCount";
    "nzText": "nzText";
    "nzColor": "nzColor";
    "nzTitle": "nzTitle";
    "nzStyle": "nzStyle";
    "nzStatus": "nzStatus";
    "nzCount": "nzCount";
    "nzOffset": "nzOffset";
}, {}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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