/**
 * @fileoverview added by tsickle
 * Generated from: partial/not-found.ts
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { ChangeDetectionStrategy, Component, ViewEncapsulation } from '@angular/core';
export class NzResultNotFoundComponent {
}
NzResultNotFoundComponent.decorators = [
    { type: Component, args: [{
                changeDetection: ChangeDetectionStrategy.OnPush,
                encapsulation: ViewEncapsulation.None,
                selector: 'nz-result-not-found',
                exportAs: 'nzResultNotFound',
                template: `
    <svg width="252" height="294">
      <defs>
        <path d="M0 .387h251.772v251.772H0z" />
      </defs>
      <g fill="none" fillRule="evenodd">
        <g transform="translate(0 .012)">
          <mask fill="#fff" />
          <path
            d="M0 127.32v-2.095C0 56.279 55.892.387 124.838.387h2.096c68.946 0 124.838 55.892 124.838 124.838v2.096c0 68.946-55.892 124.838-124.838 124.838h-2.096C55.892 252.16 0 196.267 0 127.321"
            fill="#E4EBF7"
            mask="url(#b)"
          />
        </g>
        <path d="M39.755 130.84a8.276 8.276 0 1 1-16.468-1.66 8.276 8.276 0 0 1 16.468 1.66" fill="#FFF" />
        <path d="M36.975 134.297l10.482 5.943M48.373 146.508l-12.648 10.788" stroke="#FFF" strokeWidth="2" />
        <path
          d="M39.875 159.352a5.667 5.667 0 1 1-11.277-1.136 5.667 5.667 0 0 1 11.277 1.136M57.588 143.247a5.708 5.708 0 1 1-11.358-1.145 5.708 5.708 0 0 1 11.358 1.145M99.018 26.875l29.82-.014a4.587 4.587 0 1 0-.003-9.175l-29.82.013a4.587 4.587 0 1 0 .003 9.176M110.424 45.211l29.82-.013a4.588 4.588 0 0 0-.004-9.175l-29.82.013a4.587 4.587 0 1 0 .004 9.175"
          fill="#FFF"
        />
        <path
          d="M112.798 26.861v-.002l15.784-.006a4.588 4.588 0 1 0 .003 9.175l-15.783.007v-.002a4.586 4.586 0 0 0-.004-9.172M184.523 135.668c-.553 5.485-5.447 9.483-10.931 8.93-5.485-.553-9.483-5.448-8.93-10.932.552-5.485 5.447-9.483 10.932-8.93 5.485.553 9.483 5.447 8.93 10.932"
          fill="#FFF"
        />
        <path d="M179.26 141.75l12.64 7.167M193.006 156.477l-15.255 13.011" par stroke="#FFF" strokeWidth="2" />
        <path
          d="M184.668 170.057a6.835 6.835 0 1 1-13.6-1.372 6.835 6.835 0 0 1 13.6 1.372M203.34 153.325a6.885 6.885 0 1 1-13.7-1.382 6.885 6.885 0 0 1 13.7 1.382"
          fill="#FFF"
        />
        <path
          d="M151.931 192.324a2.222 2.222 0 1 1-4.444 0 2.222 2.222 0 0 1 4.444 0zM225.27 116.056a2.222 2.222 0 1 1-4.445 0 2.222 2.222 0 0 1 4.444 0zM216.38 151.08a2.223 2.223 0 1 1-4.446-.001 2.223 2.223 0 0 1 4.446 0zM176.917 107.636a2.223 2.223 0 1 1-4.445 0 2.223 2.223 0 0 1 4.445 0zM195.291 92.165a2.223 2.223 0 1 1-4.445 0 2.223 2.223 0 0 1 4.445 0zM202.058 180.711a2.223 2.223 0 1 1-4.446 0 2.223 2.223 0 0 1 4.446 0z"
          stroke="#FFF"
          strokeWidth="2"
        />
        <path
          stroke="#FFF"
          strokeWidth="2"
          d="M214.404 153.302l-1.912 20.184-10.928 5.99M173.661 174.792l-6.356 9.814h-11.36l-4.508 6.484M174.941 125.168v-15.804M220.824 117.25l-12.84 7.901-15.31-7.902V94.39"
        />
        <path
          d="M166.588 65.936h-3.951a4.756 4.756 0 0 1-4.743-4.742 4.756 4.756 0 0 1 4.743-4.743h3.951a4.756 4.756 0 0 1 4.743 4.743 4.756 4.756 0 0 1-4.743 4.742"
          fill="#FFF"
        />
        <path
          d="M174.823 30.03c0-16.281 13.198-29.48 29.48-29.48 16.28 0 29.48 13.199 29.48 29.48 0 16.28-13.2 29.48-29.48 29.48-16.282 0-29.48-13.2-29.48-29.48"
          fill="#1890FF"
        />
        <path
          d="M205.952 38.387c.5.5.785 1.142.785 1.928s-.286 1.465-.785 1.964c-.572.5-1.214.75-2 .75-.785 0-1.429-.285-1.929-.785-.572-.5-.82-1.143-.82-1.929s.248-1.428.82-1.928c.5-.5 1.144-.75 1.93-.75.785 0 1.462.25 1.999.75m4.285-19.463c1.428 1.249 2.143 2.963 2.143 5.142 0 1.712-.427 3.13-1.219 4.25-.067.096-.137.18-.218.265-.416.429-1.41 1.346-2.956 2.699a5.07 5.07 0 0 0-1.428 1.75 5.207 5.207 0 0 0-.536 2.357v.5h-4.107v-.5c0-1.357.215-2.536.714-3.5.464-.964 1.857-2.464 4.178-4.536l.43-.5c.643-.785.964-1.643.964-2.535 0-1.18-.358-2.108-1-2.785-.678-.68-1.643-1.001-2.858-1.001-1.536 0-2.642.464-3.357 1.43-.37.5-.621 1.135-.76 1.904a1.999 1.999 0 0 1-1.971 1.63h-.004c-1.277 0-2.257-1.183-1.98-2.43.337-1.518 1.02-2.78 2.073-3.784 1.536-1.5 3.607-2.25 6.25-2.25 2.32 0 4.214.607 5.642 1.894"
          fill="#FFF"
        />
        <path
          d="M52.04 76.131s21.81 5.36 27.307 15.945c5.575 10.74-6.352 9.26-15.73 4.935-10.86-5.008-24.7-11.822-11.577-20.88"
          fill="#FFB594"
        />
        <path
          d="M90.483 67.504l-.449 2.893c-.753.49-4.748-2.663-4.748-2.663l-1.645.748-1.346-5.684s6.815-4.589 8.917-5.018c2.452-.501 9.884.94 10.7 2.278 0 0 1.32.486-2.227.69-3.548.203-5.043.447-6.79 3.132-1.747 2.686-2.412 3.624-2.412 3.624"
          fill="#FFC6A0"
        />
        <path
          d="M128.055 111.367c-2.627-7.724-6.15-13.18-8.917-15.478-3.5-2.906-9.34-2.225-11.366-4.187-1.27-1.231-3.215-1.197-3.215-1.197s-14.98-3.158-16.828-3.479c-2.37-.41-2.124-.714-6.054-1.405-1.57-1.907-2.917-1.122-2.917-1.122l-7.11-1.383c-.853-1.472-2.423-1.023-2.423-1.023l-2.468-.897c-1.645 9.976-7.74 13.796-7.74 13.796 1.795 1.122 15.703 8.3 15.703 8.3l5.107 37.11s-3.321 5.694 1.346 9.109c0 0 19.883-3.743 34.921-.329 0 0 3.047-2.546.972-8.806.523-3.01 1.394-8.263 1.736-11.622.385.772 2.019 1.918 3.14 3.477 0 0 9.407-7.365 11.052-14.012-.832-.723-1.598-1.585-2.267-2.453-.567-.736-.358-2.056-.765-2.717-.669-1.084-1.804-1.378-1.907-1.682"
          fill="#FFF"
        />
        <path
          d="M101.09 289.998s4.295 2.041 7.354 1.021c2.821-.94 4.53.668 7.08 1.178 2.55.51 6.874 1.1 11.686-1.26-.103-5.51-6.889-3.98-11.96-6.713-2.563-1.38-3.784-4.722-3.598-8.799h-9.402s-1.392 10.52-1.16 14.573"
          fill="#CBD1D1"
        />
        <path
          d="M101.067 289.826s2.428 1.271 6.759.653c3.058-.437 3.712.481 7.423 1.031 3.712.55 10.724-.069 11.823-.894.413 1.1-.343 2.063-.343 2.063s-1.512.603-4.812.824c-2.03.136-5.8.291-7.607-.503-1.787-1.375-5.247-1.903-5.728-.241-3.918.95-7.355-.286-7.355-.286l-.16-2.647z"
          fill="#2B0849"
        />
        <path d="M108.341 276.044h3.094s-.103 6.702 4.536 8.558c-4.64.618-8.558-2.303-7.63-8.558" fill="#A4AABA" />
        <path
          d="M57.542 272.401s-2.107 7.416-4.485 12.306c-1.798 3.695-4.225 7.492 5.465 7.492 6.648 0 8.953-.48 7.423-6.599-1.53-6.12.266-13.199.266-13.199h-8.669z"
          fill="#CBD1D1"
        />
        <path
          d="M51.476 289.793s2.097 1.169 6.633 1.169c6.083 0 8.249-1.65 8.249-1.65s.602 1.114-.619 2.165c-.993.855-3.597 1.591-7.39 1.546-4.145-.048-5.832-.566-6.736-1.168-.825-.55-.687-1.58-.137-2.062"
          fill="#2B0849"
        />
        <path
          d="M58.419 274.304s.033 1.519-.314 2.93c-.349 1.42-1.078 3.104-1.13 4.139-.058 1.151 4.537 1.58 5.155.034.62-1.547 1.294-6.427 1.913-7.252.619-.825-4.903-2.119-5.624.15"
          fill="#A4AABA"
        />
        <path
          d="M99.66 278.514l13.378.092s1.298-54.52 1.853-64.403c.554-9.882 3.776-43.364 1.002-63.128l-12.547-.644-22.849.78s-.434 3.966-1.195 9.976c-.063.496-.682.843-.749 1.365-.075.585.423 1.354.32 1.966-2.364 14.08-6.377 33.104-8.744 46.677-.116.666-1.234 1.009-1.458 2.691-.04.302.211 1.525.112 1.795-6.873 18.744-10.949 47.842-14.277 61.885l14.607-.014s2.197-8.57 4.03-16.97c2.811-12.886 23.111-85.01 23.111-85.01l3.016-.521 1.043 46.35s-.224 1.234.337 2.02c.56.785-.56 1.123-.392 2.244l.392 1.794s-.449 7.178-.898 11.89c-.448 4.71-.092 39.165-.092 39.165"
          fill="#7BB2F9"
        />
        <path
          d="M76.085 221.626c1.153.094 4.038-2.019 6.955-4.935M106.36 225.142s2.774-1.11 6.103-3.883"
          stroke="#648BD8"
          strokeWidth="1.051"
          strokeLinecap="round"
          strokeLinejoin="round"
        />
        <path d="M107.275 222.1s2.773-1.11 6.102-3.884" stroke="#648BD8" strokeLinecap="round" strokeLinejoin="round" />
        <path
          d="M74.74 224.767s2.622-.591 6.505-3.365M86.03 151.634c-.27 3.106.3 8.525-4.336 9.123M103.625 149.88s.11 14.012-1.293 15.065c-2.219 1.664-2.99 1.944-2.99 1.944M99.79 150.438s.035 12.88-1.196 24.377M93.673 175.911s7.212-1.664 9.431-1.664M74.31 205.861a212.013 212.013 0 0 1-.979 4.56s-1.458 1.832-1.009 3.776c.449 1.944-.947 2.045-4.985 15.355-1.696 5.59-4.49 18.591-6.348 27.597l-.231 1.12M75.689 197.807a320.934 320.934 0 0 1-.882 4.754M82.591 152.233L81.395 162.7s-1.097.15-.5 2.244c.113 1.346-2.674 15.775-5.18 30.43M56.12 274.418h13.31"
          stroke="#648BD8"
          strokeWidth="1.051"
          strokeLinecap="round"
          strokeLinejoin="round"
        />
        <path
          d="M116.241 148.22s-17.047-3.104-35.893.2c.158 2.514-.003 4.15-.003 4.15s14.687-2.818 35.67-.312c.252-2.355.226-4.038.226-4.038"
          fill="#192064"
        />
        <path
          d="M106.322 151.165l.003-4.911a.81.81 0 0 0-.778-.815c-2.44-.091-5.066-.108-7.836-.014a.818.818 0 0 0-.789.815l-.003 4.906a.81.81 0 0 0 .831.813c2.385-.06 4.973-.064 7.73.017a.815.815 0 0 0 .842-.81"
          fill="#FFF"
        />
        <path
          d="M105.207 150.233l.002-3.076a.642.642 0 0 0-.619-.646 94.321 94.321 0 0 0-5.866-.01.65.65 0 0 0-.63.647v3.072a.64.64 0 0 0 .654.644 121.12 121.12 0 0 1 5.794.011c.362.01.665-.28.665-.642"
          fill="#192064"
        />
        <path
          d="M100.263 275.415h12.338M101.436 270.53c.006 3.387.042 5.79.111 6.506M101.451 264.548a915.75 915.75 0 0 0-.015 4.337M100.986 174.965l.898 44.642s.673 1.57-.225 2.692c-.897 1.122 2.468.673.898 2.243-1.57 1.57.897 1.122 0 3.365-.596 1.489-.994 21.1-1.096 35.146"
          stroke="#648BD8"
          strokeWidth="1.051"
          strokeLinecap="round"
          strokeLinejoin="round"
        />
        <path
          d="M46.876 83.427s-.516 6.045 7.223 5.552c11.2-.712 9.218-9.345 31.54-21.655-.786-2.708-2.447-4.744-2.447-4.744s-11.068 3.11-22.584 8.046c-6.766 2.9-13.395 6.352-13.732 12.801M104.46 91.057l.941-5.372-8.884-11.43-5.037 5.372-1.74 7.834a.321.321 0 0 0 .108.32c.965.8 6.5 5.013 14.347 3.544a.332.332 0 0 0 .264-.268"
          fill="#FFC6A0"
        />
        <path
          d="M93.942 79.387s-4.533-2.853-2.432-6.855c1.623-3.09 4.513 1.133 4.513 1.133s.52-3.642 3.121-3.642c.52-1.04 1.561-4.162 1.561-4.162s11.445 2.601 13.526 3.121c0 5.203-2.304 19.424-7.84 19.861-8.892.703-12.449-9.456-12.449-9.456"
          fill="#FFC6A0"
        />
        <path
          d="M113.874 73.446c2.601-2.081 3.47-9.722 3.47-9.722s-2.479-.49-6.64-2.05c-4.683-2.081-12.798-4.747-17.48.976-9.668 3.223-2.05 19.823-2.05 19.823l2.713-3.021s-3.935-3.287-2.08-6.243c2.17-3.462 3.92 1.073 3.92 1.073s.637-2.387 3.581-3.342c.355-.71 1.036-2.674 1.432-3.85a1.073 1.073 0 0 1 1.263-.704c2.4.558 8.677 2.019 11.356 2.662.522.125.871.615.82 1.15l-.305 3.248z"
          fill="#520038"
        />
        <path
          d="M104.977 76.064c-.103.61-.582 1.038-1.07.956-.489-.083-.801-.644-.698-1.254.103-.61.582-1.038 1.07-.956.488.082.8.644.698 1.254M112.132 77.694c-.103.61-.582 1.038-1.07.956-.488-.083-.8-.644-.698-1.254.103-.61.582-1.038 1.07-.956.488.082.8.643.698 1.254"
          fill="#552950"
        />
        <path
          stroke="#DB836E"
          strokeWidth="1.118"
          strokeLinecap="round"
          strokeLinejoin="round"
          d="M110.13 74.84l-.896 1.61-.298 4.357h-2.228"
        />
        <path
          d="M110.846 74.481s1.79-.716 2.506.537"
          stroke="#5C2552"
          strokeWidth="1.118"
          strokeLinecap="round"
          strokeLinejoin="round"
        />
        <path
          d="M92.386 74.282s.477-1.114 1.113-.716c.637.398 1.274 1.433.558 1.99-.717.556.159 1.67.159 1.67"
          stroke="#DB836E"
          strokeWidth="1.118"
          strokeLinecap="round"
          strokeLinejoin="round"
        />
        <path
          d="M103.287 72.93s1.83 1.113 4.137.954"
          stroke="#5C2552"
          strokeWidth="1.118"
          strokeLinecap="round"
          strokeLinejoin="round"
        />
        <path
          d="M103.685 81.762s2.227 1.193 4.376 1.193M104.64 84.308s.954.398 1.511.318M94.693 81.205s2.308 7.4 10.424 7.639"
          stroke="#DB836E"
          strokeWidth="1.118"
          strokeLinecap="round"
          strokeLinejoin="round"
        />
        <path
          d="M81.45 89.384s.45 5.647-4.935 12.787M69 82.654s-.726 9.282-8.204 14.206"
          stroke="#E4EBF7"
          strokeWidth="1.101"
          strokeLinecap="round"
          strokeLinejoin="round"
        />
        <path
          d="M129.405 122.865s-5.272 7.403-9.422 10.768"
          stroke="#E4EBF7"
          strokeWidth="1.051"
          strokeLinecap="round"
          strokeLinejoin="round"
        />
        <path
          d="M119.306 107.329s.452 4.366-2.127 32.062"
          stroke="#E4EBF7"
          strokeWidth="1.101"
          strokeLinecap="round"
          strokeLinejoin="round"
        />
        <path
          d="M150.028 151.232h-49.837a1.01 1.01 0 0 1-1.01-1.01v-31.688c0-.557.452-1.01 1.01-1.01h49.837c.558 0 1.01.453 1.01 1.01v31.688a1.01 1.01 0 0 1-1.01 1.01"
          fill="#F2D7AD"
        />
        <path d="M150.29 151.232h-19.863v-33.707h20.784v32.786a.92.92 0 0 1-.92.92" fill="#F4D19D" />
        <path
          d="M123.554 127.896H92.917a.518.518 0 0 1-.425-.816l6.38-9.113c.193-.277.51-.442.85-.442h31.092l-7.26 10.371z"
          fill="#F2D7AD"
        />
        <path fill="#CC9B6E" d="M123.689 128.447H99.25v-.519h24.169l7.183-10.26.424.298z" />
        <path
          d="M158.298 127.896h-18.669a2.073 2.073 0 0 1-1.659-.83l-7.156-9.541h19.965c.49 0 .95.23 1.244.622l6.69 8.92a.519.519 0 0 1-.415.83"
          fill="#F4D19D"
        />
        <path
          fill="#CC9B6E"
          d="M157.847 128.479h-19.384l-7.857-10.475.415-.31 7.7 10.266h19.126zM130.554 150.685l-.032-8.177.519-.002.032 8.177z"
        />
        <path
          fill="#CC9B6E"
          d="M130.511 139.783l-.08-21.414.519-.002.08 21.414zM111.876 140.932l-.498-.143 1.479-5.167.498.143zM108.437 141.06l-2.679-2.935 2.665-3.434.41.318-2.397 3.089 2.384 2.612zM116.607 141.06l-.383-.35 2.383-2.612-2.397-3.089.41-.318 2.665 3.434z"
        />
        <path
          d="M154.316 131.892l-3.114-1.96.038 3.514-1.043.092c-1.682.115-3.634.23-4.789.23-1.902 0-2.693 2.258 2.23 2.648l-2.645-.596s-2.168 1.317.504 2.3c0 0-1.58 1.217.561 2.58-.584 3.504 5.247 4.058 7.122 3.59 1.876-.47 4.233-2.359 4.487-5.16.28-3.085-.89-5.432-3.35-7.238"
          fill="#FFC6A0"
        />
        <path
          d="M153.686 133.577s-6.522.47-8.36.372c-1.836-.098-1.904 2.19 2.359 2.264 3.739.15 5.451-.044 5.451-.044"
          stroke="#DB836E"
          strokeWidth="1.051"
          strokeLinecap="round"
          strokeLinejoin="round"
        />
        <path
          d="M145.16 135.877c-1.85 1.346.561 2.355.561 2.355s3.478.898 6.73.617"
          stroke="#DB836E"
          strokeWidth="1.051"
          strokeLinecap="round"
          strokeLinejoin="round"
        />
        <path
          d="M151.89 141.71s-6.28.111-6.73-2.132c-.223-1.346.45-1.402.45-1.402M146.114 140.868s-1.103 3.16 5.44 3.533M151.202 129.932v3.477M52.838 89.286c3.533-.337 8.423-1.248 13.582-7.754"
          stroke="#DB836E"
          strokeWidth="1.051"
          strokeLinecap="round"
          strokeLinejoin="round"
        />
        <path
          d="M168.567 248.318a6.647 6.647 0 0 1-6.647-6.647v-66.466a6.647 6.647 0 1 1 13.294 0v66.466a6.647 6.647 0 0 1-6.647 6.647"
          fill="#5BA02E"
        />
        <path
          d="M176.543 247.653a6.647 6.647 0 0 1-6.646-6.647v-33.232a6.647 6.647 0 1 1 13.293 0v33.232a6.647 6.647 0 0 1-6.647 6.647"
          fill="#92C110"
        />
        <path
          d="M186.443 293.613H158.92a3.187 3.187 0 0 1-3.187-3.187v-46.134a3.187 3.187 0 0 1 3.187-3.187h27.524a3.187 3.187 0 0 1 3.187 3.187v46.134a3.187 3.187 0 0 1-3.187 3.187"
          fill="#F2D7AD"
        />
        <path
          d="M88.979 89.48s7.776 5.384 16.6 2.842"
          stroke="#E4EBF7"
          strokeWidth="1.101"
          strokeLinecap="round"
          strokeLinejoin="round"
        />
      </g>
    </svg>
  `
            }] }
];
//# sourceMappingURL=data:application/json;base64,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