/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { ChangeDetectorRef, ElementRef, OnChanges, OnInit, Renderer2, SimpleChanges } from '@angular/core';
import { NzSkeletonAvatar, NzSkeletonParagraph, NzSkeletonTitle } from './nz-skeleton.type';
import * as ɵngcc0 from '@angular/core';
export declare class NzSkeletonComponent implements OnInit, OnChanges {
    private cdr;
    nzActive: boolean;
    nzLoading: boolean;
    nzTitle: NzSkeletonTitle | boolean;
    nzAvatar: NzSkeletonAvatar | boolean;
    nzParagraph: NzSkeletonParagraph | boolean;
    title: NzSkeletonTitle;
    avatar: NzSkeletonAvatar;
    paragraph: NzSkeletonParagraph;
    rowsList: number[];
    widthList: Array<number | string>;
    constructor(cdr: ChangeDetectorRef, renderer: Renderer2, elementRef: ElementRef);
    toCSSUnit(value?: number | string): string;
    private getTitleProps;
    private getAvatarProps;
    private getParagraphProps;
    private getProps;
    private getWidthList;
    private updateProps;
    ngOnInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzSkeletonComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzSkeletonComponent, "nz-skeleton", ["nzSkeleton"], {
    "nzActive": "nzActive";
    "nzLoading": "nzLoading";
    "nzTitle": "nzTitle";
    "nzAvatar": "nzAvatar";
    "nzParagraph": "nzParagraph";
}, {}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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