/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { AfterContentInit, EventEmitter, OnChanges, OnDestroy, OnInit, QueryList, SimpleChanges, TemplateRef } from '@angular/core';
import { NgClassType, NzSizeDSType } from 'ng-zorro-antd/core';
import { NzStepComponent } from './nz-step.component';
import * as ɵngcc0 from '@angular/core';
export declare type NzDirectionType = 'horizontal' | 'vertical';
export declare type NzStatusType = 'wait' | 'process' | 'finish' | 'error';
export declare class NzStepsComponent implements OnChanges, OnInit, OnDestroy, AfterContentInit {
    steps: QueryList<NzStepComponent>;
    nzCurrent: number;
    nzDirection: NzDirectionType;
    nzLabelPlacement: 'horizontal' | 'vertical';
    nzType: 'default' | 'navigation';
    nzSize: NzSizeDSType;
    nzStartIndex: number;
    nzStatus: NzStatusType;
    nzProgressDot: boolean | TemplateRef<{
        $implicit: TemplateRef<void>;
        status: string;
        index: number;
    }>;
    readonly nzIndexChange: EventEmitter<number>;
    private destroy$;
    private indexChangeSubscription;
    showProcessDot: boolean;
    customProcessDotTemplate: TemplateRef<{
        $implicit: TemplateRef<void>;
        status: string;
        index: number;
    }>;
    classMap: NgClassType;
    ngOnChanges(changes: SimpleChanges): void;
    ngOnInit(): void;
    ngOnDestroy(): void;
    ngAfterContentInit(): void;
    private updateChildrenSteps;
    private setClassMap;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzStepsComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzStepsComponent, "nz-steps", ["nzSteps"], {
    "nzCurrent": "nzCurrent";
    "nzDirection": "nzDirection";
    "nzLabelPlacement": "nzLabelPlacement";
    "nzType": "nzType";
    "nzSize": "nzSize";
    "nzStartIndex": "nzStartIndex";
    "nzStatus": "nzStatus";
    "nzProgressDot": "nzProgressDot";
}, {
    "nzIndexChange": "nzIndexChange";
}, ["steps"]>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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