/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { CdkConnectedOverlay, CdkOverlayOrigin, ConnectedOverlayPositionChange, ConnectionPositionPair } from '@angular/cdk/overlay';
import { ChangeDetectorRef, EventEmitter, TemplateRef } from '@angular/core';
import { NgClassInterface, NgStyleInterface, NzNoAnimationDirective, NzTSType } from 'ng-zorro-antd/core';
import { NzTooltipTrigger } from '../nz-tooltip.definitions';
/**
 * Tooltip component. Also the base component for legacy components.
 */
import * as ɵngcc0 from '@angular/core';
export declare abstract class NzTooltipBaseComponent {
    cdr: ChangeDetectorRef;
    noAnimation?: NzNoAnimationDirective | undefined;
    nzTitle: NzTSType | null;
    nzContent: NzTSType | null;
    nzVisible: boolean;
    nzPlacement: string;
    nzOverlayClassName: string;
    nzOverlayStyle: NgStyleInterface;
    nzMouseEnterDelay: number;
    nzMouseLeaveDelay: number;
    nzTrigger: NzTooltipTrigger;
    nzTitleTemplate: TemplateRef<void>;
    nzContentTemplate: TemplateRef<void>;
    readonly nzVisibleChange: EventEmitter<boolean>;
    overlay: CdkConnectedOverlay;
    origin: CdkOverlayOrigin;
    _classMap: NgClassInterface;
    _hasBackdrop: boolean;
    _prefix: string;
    _visible: boolean;
    _positions: ConnectionPositionPair[];
    _placement: string;
    _trigger: NzTooltipTrigger;
    readonly content: string | TemplateRef<void> | null;
    readonly title: string | TemplateRef<void> | null;
    constructor(cdr: ChangeDetectorRef, noAnimation?: NzNoAnimationDirective | undefined);
    show(): void;
    hide(): void;
    updateByDirective(): void;
    /**
     * Force the component to update its position.
     */
    updatePosition(): void;
    onPositionChange(position: ConnectedOverlayPositionChange): void;
    setClassMap(): void;
    setOverlayOrigin(origin: CdkOverlayOrigin): void;
    private isTitleEmpty;
    private isContentEmpty;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzTooltipBaseComponent>;
    static ɵdir: ɵngcc0.ɵɵDirectiveDefWithMeta<NzTooltipBaseComponent, never, never, {}, {
    "nzVisibleChange": "nzVisibleChange";
}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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