let fs = require('fs');
const compressing = require('compressing');

function fix2(num) {
    if (num >= 10) {
        return '' + num;
    } else {
        return '0' + num;
    }
}

async function copyDir(src, dst) {
    const exists = await fs.existsSync(dst);
    if (!exists) {
        await fs.mkdirSync(dst);
    }
    //读取目录
    const paths = await fs.readdirSync(src);
    for (let i = 0; i < paths.length; i++) {
        let path = paths[i];
        const newSrc = `${src}/${path}`;
        const newDst = `${dst}/${path}`;
        const st = await fs.statSync(newSrc);
        if (st.isFile()) {
            console.log('copy: ' + newDst);
            const data = await fs.readFileSync(newSrc);
            await fs.writeFileSync(newDst, data);
        } else if (st.isDirectory()) {
            copyDir(newSrc, newDst);
        }
    }
}

async function removeDir(src) {
    const exists = await fs.existsSync(src);
    if (!exists) {
        return;
    }

    //读取目录
    const st = await fs.statSync(src);
    console.log(st);
    const paths = await fs.readdirSync(src);
    for (let i = 0; i < paths.length; i++) {
        let path = paths[i];
        const newSrc = `${src}/${path}`;
        const st = await fs.statSync(newSrc);
        if (st.isFile()) {
            console.log('remove: ' + newSrc);
            await fs.unlinkSync(newSrc);
        } else if (st.isDirectory()) {
            await removeDir(newSrc);
        }
    }
    await fs.rmdirSync(src);
}

async function main() {
    let date = new Date();
    let fileName = `Release_${date.getFullYear()}${fix2(date.getMonth() + 1)}${fix2(date.getDate())} `;
    fileName += `${fix2(date.getHours())}-${fix2(date.getMinutes())}-${fix2(date.getSeconds())}`;

    await removeDir('../publish/play');
    await removeDir('../publish/form');

    await copyDir('../play/build/web-desktop', '../publish/play');

    compressing.zip.uncompress('../form/publish/form.zip', '../publish/form')
        .then(() => {
            const tarStream = new compressing.zip.Stream();
            tarStream.addEntry('../publish/play');
            tarStream.addEntry('../publish/form');

            const destStream = fs.createWriteStream(`../publish/${fileName}.zip`);

            tarStream.pipe(destStream);

            console.log('打包完成！');
        });
}

main();