/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/compiler-cli/src/ngtsc/transform/src/api", ["require", "exports"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var HandlerPrecedence;
    (function (HandlerPrecedence) {
        /**
         * Handler with PRIMARY precedence cannot overlap - there can only be one on a given class.
         *
         * If more than one PRIMARY handler matches a class, an error is produced.
         */
        HandlerPrecedence[HandlerPrecedence["PRIMARY"] = 0] = "PRIMARY";
        /**
         * Handlers with SHARED precedence can match any class, possibly in addition to a single PRIMARY
         * handler.
         *
         * It is not an error for a class to have any number of SHARED handlers.
         */
        HandlerPrecedence[HandlerPrecedence["SHARED"] = 1] = "SHARED";
        /**
         * Handlers with WEAK precedence that match a class are ignored if any handlers with stronger
         * precedence match a class.
         */
        HandlerPrecedence[HandlerPrecedence["WEAK"] = 2] = "WEAK";
    })(HandlerPrecedence = exports.HandlerPrecedence || (exports.HandlerPrecedence = {}));
    /**
     * A set of options which can be passed to a `DecoratorHandler` by a consumer, to tailor the output
     * of compilation beyond the decorators themselves.
     */
    var HandlerFlags;
    (function (HandlerFlags) {
        /**
         * No flags set.
         */
        HandlerFlags[HandlerFlags["NONE"] = 0] = "NONE";
        /**
         * Indicates that this decorator is fully inherited from its parent at runtime. In addition to
         * normally inherited aspects such as inputs and queries, full inheritance applies to every aspect
         * of the component or directive, such as the template function itself.
         *
         * Its primary effect is to cause the `CopyDefinitionFeature` to be applied to the definition
         * being compiled. See that class for more information.
         */
        HandlerFlags[HandlerFlags["FULL_INHERITANCE"] = 1] = "FULL_INHERITANCE";
    })(HandlerFlags = exports.HandlerFlags || (exports.HandlerFlags = {}));
});
//# sourceMappingURL=data:application/json;base64,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