/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { FocusMonitor } from '@angular/cdk/a11y';
import { AfterViewInit, ChangeDetectorRef, ElementRef, EventEmitter, OnChanges, OnDestroy, OnInit, Renderer2, SimpleChanges } from '@angular/core';
import { ControlValueAccessor } from '@angular/forms';
import { NzSizeLDSType } from 'ng-zorro-antd/core';
import * as ɵngcc0 from '@angular/core';
export declare class NzInputNumberComponent implements ControlValueAccessor, AfterViewInit, OnChanges, OnInit, OnDestroy {
    private elementRef;
    private renderer;
    private cdr;
    private focusMonitor;
    private autoStepTimer;
    private actualValue;
    private value;
    displayValue: string | number;
    isFocused: boolean;
    disabledUp: boolean;
    disabledDown: boolean;
    onChange: (value: number) => void;
    onTouched: () => void;
    readonly nzBlur: EventEmitter<any>;
    readonly nzFocus: EventEmitter<any>;
    inputElement: ElementRef<HTMLInputElement>;
    nzSize: NzSizeLDSType;
    nzMin: number;
    nzMax: number;
    nzParser: (value: any) => any;
    nzPrecision: number;
    nzPlaceHolder: string;
    nzStep: number;
    nzId: string;
    nzDisabled: boolean;
    nzAutoFocus: boolean;
    nzFormatter: (value: number) => string | number;
    [property: string]: any;
    updateAutoFocus(): void;
    onModelChange(value: string): void;
    getCurrentValidValue(value: string | number): number;
    isNotCompleteNumber(num: string | number): boolean;
    getValidValue(value?: string | number): string | number | undefined;
    toNumber(num: string | number): number;
    setValidateValue(): void;
    onBlur(): void;
    onFocus(): void;
    getRatio(e: KeyboardEvent): number;
    down(e: MouseEvent | KeyboardEvent, ratio?: number): void;
    up(e: MouseEvent | KeyboardEvent, ratio?: number): void;
    getPrecision(value: number): number;
    getMaxPrecision(currentValue: string | number, ratio: number): number;
    getPrecisionFactor(currentValue: string | number, ratio: number): number;
    upStep(val: string | number, rat: number): number;
    downStep(val: string | number, rat: number): number;
    step(type: string, e: MouseEvent | KeyboardEvent, ratio?: number): void;
    stop(): void;
    setValue(value: number, emit: boolean): void;
    onKeyDown(e: KeyboardEvent): void;
    onKeyUp(): void;
    writeValue(value: number): void;
    registerOnChange(fn: (_: number) => void): void;
    registerOnTouched(fn: () => void): void;
    setDisabledState(isDisabled: boolean): void;
    focus(): void;
    blur(): void;
    constructor(elementRef: ElementRef, renderer: Renderer2, cdr: ChangeDetectorRef, focusMonitor: FocusMonitor);
    ngOnInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    ngAfterViewInit(): void;
    ngOnDestroy(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzInputNumberComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzInputNumberComponent, "nz-input-number", ["nzInputNumber"], {
    "nzSize": "nzSize";
    "nzMin": "nzMin";
    "nzMax": "nzMax";
    "nzParser": "nzParser";
    "nzPlaceHolder": "nzPlaceHolder";
    "nzStep": "nzStep";
    "nzDisabled": "nzDisabled";
    "nzAutoFocus": "nzAutoFocus";
    "nzFormatter": "nzFormatter";
    "nzPrecision": "nzPrecision";
    "nzId": "nzId";
}, {
    "nzBlur": "nzBlur";
    "nzFocus": "nzFocus";
}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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