/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { AfterViewInit, ChangeDetectorRef, ElementRef, EventEmitter, NgZone, OnDestroy, OnInit, Renderer2, TemplateRef } from '@angular/core';
import { MediaMatcher } from '@angular/cdk/layout';
import { Platform } from '@angular/cdk/platform';
import { NzBreakPoint, NzDomEventService } from 'ng-zorro-antd/core';
import { NzLayoutComponent } from './nz-layout.component';
import * as ɵngcc0 from '@angular/core';
export declare class NzSiderComponent implements OnInit, AfterViewInit, OnDestroy {
    private nzLayoutComponent;
    private mediaMatcher;
    private ngZone;
    private platform;
    private cdr;
    private nzDomEventService;
    private below;
    private destroy$;
    private dimensionMap;
    readonly nzCollapsedChange: EventEmitter<any>;
    nzWidth: string | number;
    nzTheme: 'light' | 'dark';
    nzCollapsedWidth: number;
    nzBreakpoint: NzBreakPoint;
    nzZeroTrigger: TemplateRef<void>;
    nzReverseArrow: boolean;
    nzCollapsible: boolean;
    nzCollapsed: boolean;
    nzTrigger: TemplateRef<void>;
    defaultTrigger: TemplateRef<void>;
    readonly trigger: TemplateRef<void>;
    readonly flexSetting: string;
    readonly widthSetting: string;
    watchMatchMedia(): void;
    toggleCollapse(): void;
    readonly isZeroTrigger: boolean;
    readonly isSiderTrigger: boolean;
    constructor(nzLayoutComponent: NzLayoutComponent, mediaMatcher: MediaMatcher, ngZone: NgZone, platform: Platform, cdr: ChangeDetectorRef, nzDomEventService: NzDomEventService, renderer: Renderer2, elementRef: ElementRef);
    ngOnInit(): void;
    ngAfterViewInit(): void;
    ngOnDestroy(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzSiderComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzSiderComponent, "nz-sider", ["nzSider"], {
    "nzWidth": "nzWidth";
    "nzTheme": "nzTheme";
    "nzCollapsedWidth": "nzCollapsedWidth";
    "nzReverseArrow": "nzReverseArrow";
    "nzCollapsible": "nzCollapsible";
    "nzCollapsed": "nzCollapsed";
    "nzBreakpoint": "nzBreakpoint";
    "nzZeroTrigger": "nzZeroTrigger";
    "nzTrigger": "nzTrigger";
}, {
    "nzCollapsedChange": "nzCollapsedChange";
}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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