import { Component, OnDestroy, OnChanges, OnInit, ApplicationRef, ChangeDetectorRef, ViewChild, ElementRef } from '@angular/core';
import { ComponentBase } from './ComponentBase';
import { MetaFormCreator } from './mataFormCreator';

let replaceAll = function (str, s1, s2) {
  return str.replace(new RegExp(s1, "gm"), s2);
}
@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent extends ComponentBase implements OnInit, OnChanges, OnDestroy {
  // 储存数据用
  saveKey = "hy02_paopao";

  item = {
    // imgAni: {
    //   ske: {},
    //   tex: {},
    //   png: {}
    // },
    startAudio: "",
    audioName: "",
    title: "泡泡选择",

    questions: [],
  };

  isVisible = false;
  deleteTitle = "是否删除题目";
  deleteCallback = function () { };
  openDelete(title, callback) {
    this.deleteCallback = callback;
    this.deleteTitle = title;
    this.isVisible = true;
  }
  handleCancel() {
    this.isVisible = false;
  }
  handleOk() {
    this.deleteCallback && this.deleteCallback();
    this.handleCancel();
  }
  init(): void {
    console.log(new MetaFormCreator().create());
  }

  removeoption(i, j) {
    this.openDelete("确定删除选项？", () => {
      this.item.questions[i].options.splice(j, 1);
      this.save();
    })
  }
  copyoption(i, j) {
    let data = this.item.questions[i].options[j];
    this.item.questions[i].options.push(JSON.parse(JSON.stringify(data)));
    this.save();
  }

  addoption(i) {
    this.item.questions[i].options.push({
      type: "txt",
      image: "",
      audio: "",
      text: "",
      time: "",
      right: false
    });
    this.save();
  }

  removequestion(idx) {
    this.openDelete("确定删除题目？", () => {
      this.item.questions.splice(idx, 1);
      this.save();
    })
  }

  addquestion() {
    this.item.questions.push({
      options: [],
      type: "txt",
      audioUrl: "",
      audioName: "",
      text: "",
      questImg:""
    });
    this.save();
  }
  ngChange() {
    this.save();
  }

  changeMain(question) {
    //输出的数据可以识别到\n的换行符
    let arr = question.contentMain.split(" ");
    let oldArr = question.contentArr.concat();
    let contetArr = arr.map(ar => {
      let obj = {
        text: `${ar}`,//replaceAll(`${ar}`, "\n", "<br/>"),
        block: false,
        check: 1,
      }
      for (let i = 0; i < oldArr.length; i++) {
        if (obj.text == oldArr[i].text) {
          obj.block = oldArr[i].block;
          obj.check = oldArr[i].check;
          oldArr.splice(i, 1);
          break;
        }
      }
      return obj;
    })
    question.contentArr = contetArr;
    console.log(contetArr)
    this.save();
  }
  onBlock(item, vis) {
    item.block = vis;
    this.save();
  }


  onDragonBoneSave(e, item) {
    console.log(e);
    this.save();
  }
}