import { ElementRef, OnChanges, Renderer2, SimpleChanges } from '@angular/core';
import { IconDefinition, ThemeType } from '../types';
import { IconService } from './icon.service';
import * as ɵngcc0 from '@angular/core';
export declare class IconDirective implements OnChanges {
    protected _iconService: IconService;
    protected _elementRef: ElementRef;
    protected _renderer: Renderer2;
    type: string | IconDefinition;
    theme: ThemeType;
    twoToneColor: string;
    constructor(_iconService: IconService, _elementRef: ElementRef, _renderer: Renderer2);
    ngOnChanges(changes: SimpleChanges): void;
    /**
     * Render a new icon in the current element. Remove the icon when `type` is falsy.
     */
    protected _changeIcon(): Promise<SVGElement | null>;
    /**
     * Parse a icon to the standard form, an `IconDefinition` or a string like 'account-book-fill` (with a theme suffixed).
     * If namespace is specified, ignore theme because it meaningless for users' icons.
     * @param type
     * @param theme
     */
    protected _parseIconType(type: string | IconDefinition, theme: ThemeType): IconDefinition | string;
    protected _setSVGElement(svg: SVGElement): void;
    protected _clearSVGElement(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<IconDirective>;
    static ɵdir: ɵngcc0.ɵɵDirectiveDefWithMeta<IconDirective, "[antIcon]", never, {
    "type": "type";
    "theme": "theme";
    "twoToneColor": "twoToneColor";
}, {}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaWNvbi5kaXJlY3RpdmUuZC50cyIsInNvdXJjZXMiOlsiaWNvbi5kaXJlY3RpdmUuZC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtBQUNBO0FBQ0E7O0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Ozs7Ozs7QUFDQSIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEVsZW1lbnRSZWYsIE9uQ2hhbmdlcywgUmVuZGVyZXIyLCBTaW1wbGVDaGFuZ2VzIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQgeyBJY29uRGVmaW5pdGlvbiwgVGhlbWVUeXBlIH0gZnJvbSAnLi4vdHlwZXMnO1xuaW1wb3J0IHsgSWNvblNlcnZpY2UgfSBmcm9tICcuL2ljb24uc2VydmljZSc7XG5leHBvcnQgZGVjbGFyZSBjbGFzcyBJY29uRGlyZWN0aXZlIGltcGxlbWVudHMgT25DaGFuZ2VzIHtcbiAgICBwcm90ZWN0ZWQgX2ljb25TZXJ2aWNlOiBJY29uU2VydmljZTtcbiAgICBwcm90ZWN0ZWQgX2VsZW1lbnRSZWY6IEVsZW1lbnRSZWY7XG4gICAgcHJvdGVjdGVkIF9yZW5kZXJlcjogUmVuZGVyZXIyO1xuICAgIHR5cGU6IHN0cmluZyB8IEljb25EZWZpbml0aW9uO1xuICAgIHRoZW1lOiBUaGVtZVR5cGU7XG4gICAgdHdvVG9uZUNvbG9yOiBzdHJpbmc7XG4gICAgY29uc3RydWN0b3IoX2ljb25TZXJ2aWNlOiBJY29uU2VydmljZSwgX2VsZW1lbnRSZWY6IEVsZW1lbnRSZWYsIF9yZW5kZXJlcjogUmVuZGVyZXIyKTtcbiAgICBuZ09uQ2hhbmdlcyhjaGFuZ2VzOiBTaW1wbGVDaGFuZ2VzKTogdm9pZDtcbiAgICAvKipcbiAgICAgKiBSZW5kZXIgYSBuZXcgaWNvbiBpbiB0aGUgY3VycmVudCBlbGVtZW50LiBSZW1vdmUgdGhlIGljb24gd2hlbiBgdHlwZWAgaXMgZmFsc3kuXG4gICAgICovXG4gICAgcHJvdGVjdGVkIF9jaGFuZ2VJY29uKCk6IFByb21pc2U8U1ZHRWxlbWVudCB8IG51bGw+O1xuICAgIC8qKlxuICAgICAqIFBhcnNlIGEgaWNvbiB0byB0aGUgc3RhbmRhcmQgZm9ybSwgYW4gYEljb25EZWZpbml0aW9uYCBvciBhIHN0cmluZyBsaWtlICdhY2NvdW50LWJvb2stZmlsbGAgKHdpdGggYSB0aGVtZSBzdWZmaXhlZCkuXG4gICAgICogSWYgbmFtZXNwYWNlIGlzIHNwZWNpZmllZCwgaWdub3JlIHRoZW1lIGJlY2F1c2UgaXQgbWVhbmluZ2xlc3MgZm9yIHVzZXJzJyBpY29ucy5cbiAgICAgKiBAcGFyYW0gdHlwZVxuICAgICAqIEBwYXJhbSB0aGVtZVxuICAgICAqL1xuICAgIHByb3RlY3RlZCBfcGFyc2VJY29uVHlwZSh0eXBlOiBzdHJpbmcgfCBJY29uRGVmaW5pdGlvbiwgdGhlbWU6IFRoZW1lVHlwZSk6IEljb25EZWZpbml0aW9uIHwgc3RyaW5nO1xuICAgIHByb3RlY3RlZCBfc2V0U1ZHRWxlbWVudChzdmc6IFNWR0VsZW1lbnQpOiB2b2lkO1xuICAgIHByb3RlY3RlZCBfY2xlYXJTVkdFbGVtZW50KCk6IHZvaWQ7XG59XG4iXX0=