import { HttpBackend, HttpClient } from '@angular/common/http';
import { Renderer2, RendererFactory2 } from '@angular/core';
import { DomSanitizer } from '@angular/platform-browser';
import { Observable } from 'rxjs';
import { CachedIconDefinition, IconDefinition, ThemeType, TwoToneColorPalette, TwoToneColorPaletteSetter } from '../types';
import * as ɵngcc0 from '@angular/core';
export declare class IconService {
    protected _rendererFactory: RendererFactory2;
    protected _handler: HttpBackend;
    protected _document: any;
    protected sanitizer: DomSanitizer;
    defaultTheme: ThemeType;
    twoToneColor: TwoToneColorPaletteSetter;
    protected _renderer: Renderer2;
    protected _http: HttpClient;
    /**
     * All icon definitions would be registered here.
     */
    protected readonly _svgDefinitions: Map<string, IconDefinition>;
    /**
     * Cache all rendered icons. Icons are identified by name, theme,
     * and for twotone icons, primary color and secondary color.
     */
    protected readonly _svgRenderedDefinitions: Map<string, CachedIconDefinition>;
    protected _inProgressFetches: Map<string, Observable<IconDefinition | null>>;
    /**
     * Url prefix for fetching inline SVG by dynamic importing.
     */
    protected _assetsUrlRoot: string;
    protected _twoToneColorPalette: TwoToneColorPalette;
    /** A flag indicates whether jsonp loading is enabled. */
    private _enableJsonpLoading;
    private readonly _jsonpIconLoad$;
    constructor(_rendererFactory: RendererFactory2, _handler: HttpBackend, _document: any, sanitizer: DomSanitizer);
    /**
     * Call this method to switch to jsonp like loading.
     */
    useJsonpLoading(): void;
    /**
     * Change the prefix of the inline svg resources, so they could be deployed elsewhere, like CDN.
     * @param prefix
     */
    changeAssetsSource(prefix: string): void;
    /**
     * Add icons provided by ant design.
     * @param icons
     */
    addIcon(...icons: IconDefinition[]): void;
    /**
     * Register an icon. Namespace is required.
     * @param type
     * @param literal
     */
    addIconLiteral(type: string, literal: string): void;
    /**
     * Remove all cache.
     */
    clear(): void;
    /**
     * Get a rendered `SVGElement`.
     * @param icon
     * @param twoToneColor
     */
    getRenderedContent(icon: IconDefinition | string, twoToneColor?: string): Observable<SVGElement>;
    getCachedIcons(): Map<string, IconDefinition>;
    /**
     * Get raw svg and assemble a `IconDefinition` object.
     * @param type
     */
    protected _loadIconDynamically(type: string): Observable<IconDefinition | null>;
    protected _loadIconDynamicallyWithJsonp(icon: IconDefinition, url: string): Observable<IconDefinition>;
    /**
     * Render a new `SVGElement` for a given `IconDefinition`, or make a copy from cache.
     * @param icon
     * @param twoToneColor
     */
    protected _loadSVGFromCacheOrCreateNew(icon: IconDefinition, twoToneColor?: string): SVGElement;
    protected _createSVGElementFromString(str: string): SVGElement;
    protected _setSVGAttribute(svg: SVGElement): SVGElement;
    protected _colorizeSVGIcon(svg: SVGElement, twotone: boolean, pri: string, sec: string): SVGElement;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<IconService>;
    static ɵprov: ɵngcc0.ɵɵInjectableDef<IconService>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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