/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { error, ANT_ICON_ANGULAR_CONSOLE_PREFIX } from '../utils';
/**
 * @return {?}
 */
export function NameSpaceIsNotSpecifyError() {
    return new Error(`${ANT_ICON_ANGULAR_CONSOLE_PREFIX}Type should have a namespace. Try "namespace:${name}".`);
}
/**
 * @param {?} icon
 * @return {?}
 */
export function IconNotFoundError(icon) {
    return new Error(`${ANT_ICON_ANGULAR_CONSOLE_PREFIX}the icon ${icon} does not exist or is not registered.`);
}
/**
 * @return {?}
 */
export function HttpModuleNotImport() {
    error(`you need to import "HttpClientModule" to use dynamic importing.`);
    return null;
}
/**
 * @param {?} url
 * @return {?}
 */
export function UrlNotSafeError(url) {
    return new Error(`${ANT_ICON_ANGULAR_CONSOLE_PREFIX}The url "${url}" is unsafe.`);
}
/**
 * @return {?}
 */
export function SVGTagNotFoundError() {
    return new Error(`${ANT_ICON_ANGULAR_CONSOLE_PREFIX}<svg> tag not found.`);
}
/**
 * @return {?}
 */
export function DynamicLoadingTimeoutError() {
    return new Error(`${ANT_ICON_ANGULAR_CONSOLE_PREFIX}Importing timeout error.`);
}
//# sourceMappingURL=data:application/json;base64,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