/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { ChangeDetectorRef, ElementRef, EventEmitter } from '@angular/core';
import * as ɵngcc0 from '@angular/core';
export declare class NzOptionSelectionChange {
    source: NzAutocompleteOptionComponent;
    isUserInput: boolean;
    constructor(source: NzAutocompleteOptionComponent, isUserInput?: boolean);
}
export declare class NzAutocompleteOptionComponent {
    private changeDetectorRef;
    private element;
    nzValue: any;
    nzLabel: string;
    nzDisabled: boolean;
    readonly selectionChange: EventEmitter<NzOptionSelectionChange>;
    active: boolean;
    selected: boolean;
    constructor(changeDetectorRef: ChangeDetectorRef, element: ElementRef);
    select(emit?: boolean): void;
    deselect(): void;
    /** Git display label */
    getLabel(): string;
    /** Set active (only styles) */
    setActiveStyles(): void;
    /** Unset active (only styles) */
    setInactiveStyles(): void;
    scrollIntoViewIfNeeded(): void;
    selectViaInteraction(): void;
    private emitSelectionChangeEvent;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzAutocompleteOptionComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzAutocompleteOptionComponent, "nz-auto-option", ["nzAutoOption"], {
    "nzDisabled": "nzDisabled";
    "nzValue": "nzValue";
    "nzLabel": "nzLabel";
}, {
    "selectionChange": "selectionChange";
}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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