/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
/**
 * Some singletons should have life cycle that is same to Angular's. This service make sure that
 * those singletons get destroyed in HMR.
 */
import * as ɵngcc0 from '@angular/core';
export declare class NzSingletonService {
    private readonly singletonRegistry;
    /**
     * This registry is used to register singleton in dev mode.
     * So that singletons get destroyed when hot module reload happens.
     *
     * This works in prod mode too but with no specific effect.
     */
    private _singletonRegistry;
    registerSingletonWithKey(key: string, target: any): void;
    getSingletonWithKey<T>(key: string): T | null;
    private withNewTarget;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzSingletonService>;
    static ɵprov: ɵngcc0.ɵɵInjectableDef<NzSingletonService>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibnotc2luZ2xldG9uLnNlcnZpY2UuZC50cyIsInNvdXJjZXMiOlsibnotc2luZ2xldG9uLnNlcnZpY2UuZC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7O0FBQ0EiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEBsaWNlbnNlXG4gKiBDb3B5cmlnaHQgQWxpYmFiYS5jb20gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2dpdGh1Yi5jb20vTkctWk9SUk8vbmctem9ycm8tYW50ZC9ibG9iL21hc3Rlci9MSUNFTlNFXG4gKi9cbi8qKlxuICogU29tZSBzaW5nbGV0b25zIHNob3VsZCBoYXZlIGxpZmUgY3ljbGUgdGhhdCBpcyBzYW1lIHRvIEFuZ3VsYXIncy4gVGhpcyBzZXJ2aWNlIG1ha2Ugc3VyZSB0aGF0XG4gKiB0aG9zZSBzaW5nbGV0b25zIGdldCBkZXN0cm95ZWQgaW4gSE1SLlxuICovXG5leHBvcnQgZGVjbGFyZSBjbGFzcyBOelNpbmdsZXRvblNlcnZpY2Uge1xuICAgIHByaXZhdGUgcmVhZG9ubHkgc2luZ2xldG9uUmVnaXN0cnk7XG4gICAgLyoqXG4gICAgICogVGhpcyByZWdpc3RyeSBpcyB1c2VkIHRvIHJlZ2lzdGVyIHNpbmdsZXRvbiBpbiBkZXYgbW9kZS5cbiAgICAgKiBTbyB0aGF0IHNpbmdsZXRvbnMgZ2V0IGRlc3Ryb3llZCB3aGVuIGhvdCBtb2R1bGUgcmVsb2FkIGhhcHBlbnMuXG4gICAgICpcbiAgICAgKiBUaGlzIHdvcmtzIGluIHByb2QgbW9kZSB0b28gYnV0IHdpdGggbm8gc3BlY2lmaWMgZWZmZWN0LlxuICAgICAqL1xuICAgIHByaXZhdGUgX3NpbmdsZXRvblJlZ2lzdHJ5O1xuICAgIHJlZ2lzdGVyU2luZ2xldG9uV2l0aEtleShrZXk6IHN0cmluZywgdGFyZ2V0OiBhbnkpOiB2b2lkO1xuICAgIGdldFNpbmdsZXRvbldpdGhLZXk8VD4oa2V5OiBzdHJpbmcpOiBUIHwgbnVsbDtcbiAgICBwcml2YXRlIHdpdGhOZXdUYXJnZXQ7XG59XG4iXX0=